# Qaya HRM (EMS) - Multitenant Edition

A comprehensive **multitenant** Qaya HRM inspired by Odoo, built with Laravel 12 and Bootstrap 5.

## 🏢 Multitenancy Features

### **Three-Tier User System**
- **SystemAdmin** - Manages all organizations globally
- **Organization Admin** - Manages their organization and staff
- **Staff** - Regular employees within organizations

### **Complete Data Isolation**
- Single database with organization-scoped data
- Automatic tenant filtering through global scopes
- Secure middleware-based access control

### **Dual Authentication**
- `/systemadmin/login` - SystemAdmin access
- `/login` - Organization user access
- Separate dashboards and interfaces

## 🎯 Key Features

### 👥 Employee Management
- Complete employee profiles with personal & work information
- Employee hierarchy (Manager-Subordinate relationship)
- Employee status tracking (Active, Inactive, On Leave, Terminated)
- Photo upload and profile management
- Emergency contact information
- Bank account details
- **Excel/CSV Import/Export** - Bulk employee data management
- **Group By** - View employees grouped by Department, Position, or Status
- **Document Management** - Upload and manage employee documents (ID, Contract, Certificate, Other)

### 🏢 Department & Position Management
- Hierarchical department structure
- Department-wise employee grouping
- Position definitions with required skills
- Color-coded organization

### ⏰ Attendance Management
- **Employee Self-Service Check-in/Check-out** with time validation
- **Admin-Configurable Time Windows:**
  - Set earliest/latest check-in times (default: 6:00 AM - 12:00 PM)
  - Set earliest/latest check-out times (default: 3:00 PM - 11:59 PM)
  - Configure official work hours (default: 9:00 AM - 5:00 PM)
  - Set late arrival threshold (default: 15 minutes)
  - Set early leave threshold (default: 15 minutes)
  - Define half-day and full-day hours
  - Weekend check-in toggle
  - Required check-out option
- **Auto Status Detection:**
  - Marks "Late" if check-in exceeds threshold
  - Determines "Half Day" or "Present" based on worked hours
  - Detects early leave
- IP address logging for security
- Monthly attendance reports
- Dashboard quick check-in/check-out

### 🏖️ Leave Management
- Multiple leave types (Annual, Sick, Casual, Maternity, Paternity, Unpaid)
- Leave request workflow (Submit → Approve/Reject)
- Leave balance tracking per employee
- **Leave Calendar View** - Visual calendar with color-coded leave types using FullCalendar
- Approval system with reasons
- Leave reports

### 💰 Payroll Management
- Monthly payroll generation
- Salary components (Basic, Allowances, Bonuses, Overtime)
- Deductions (Tax, Insurance, Other)
- Attendance-based salary calculation
- Bulk payroll generation
- **Export Options** - Download payroll reports

### 📊 Reports & Analytics
- **PDF Export** - Generate PDF reports for:
  - Attendance reports
  - Leave reports
  - Payroll reports
  - Employee directory
- **Excel/CSV Export** - Export data for:
  - Employees
  - Attendance records
  - Leave requests
  - Payroll data
- Dashboard with key metrics and statistics

### 🔐 Roles & Permissions System
- **5 Default Roles:**
  - **Administrator** - Full system access
  - **HR Manager** - Employee, attendance, leave, performance management
  - **Accountant** - Payroll and financial reports
  - **Department Manager** - Team management, leave approvals
  - **Employee** - Self-service access only
- **Permission-Based UI** - Menu items and buttons hidden based on user permissions
- **32 Granular Permissions** across all modules
- **User Management** - Assign roles to users, change passwords

### ⚙️ Settings & Configuration
- Company settings management
- Leave types configuration
- Position management
- Holiday calendar
- **Attendance Settings** - Configure check-in/check-out rules
- Roles & permissions management
- User management with role assignment

### 📱 Employee Self-Service
- Dashboard with attendance status
- Quick check-in/check-out buttons
- View personal attendance history
- Apply for leaves
- View leave balances
- Download payslips
- Update profile information

### 📄 Document Management
- Upload employee documents (ID Card, Contract, Certificates, Other)
- Download documents
- Organize by document type
- Delete documents with confirmation

### 🎨 User Interface
- Clean, modern Bootstrap 5 design
- Odoo purple theme (#714b67)
- Responsive layout
- Bootstrap Icons
- Real-time time display
- Color-coded status badges
- Interactive calendar views

## 🚀 Installation

### Prerequisites
- PHP >= 8.2
- Composer
- MySQL/MariaDB
- Node.js & NPM

### Setup Steps

1. **Install dependencies**
```bash
composer install
npm install
```

2. **Environment setup**
```bash
copy .env.example .env
php artisan key:generate
```

3. **Configure database in .env**
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=employee_management
DB_USERNAME=root
DB_PASSWORD=
```

4. **Database setup**
```bash
php artisan migrate
php artisan db:seed
```

5. **Storage and assets**
```bash
php artisan storage:link
npm run build
```

6. **Start server**
```bash
php artisan serve
```

Visit: `http://localhost:8000`

## 👤 Default Login Credentials

**SystemAdmin Account:**
- URL: `/systemadmin/login`
- Email: `systemadmin@example.com`
- Password: `password`

**Organization Admin Account:**
- URL: `/login`
- Email: `qayacreatives@gmail.com`
- Password: `password`

## 🏢 Organization Management

### Create New Organization (CLI)
```bash
php artisan org:create "Company Name" admin@company.com "Admin Name"
```

### List Organizations
```bash
php artisan org:list
```

### Test Multitenancy
```bash
php artisan test:multitenancy
```

## � Required Packages

- `maatwebsite/excel` - Excel/CSV import/export
- `barryvdh/laravel-dompdf` - PDF generation
- Laravel 12 framework

## 🎯 Key Highlights

✅ **Odoo-Inspired UI/UX** - Professional enterprise look and feel
✅ **Role-Based Access Control** - Granular permissions system
✅ **Employee Self-Service** - Empower employees with self-check-in and profile management
✅ **Time-Based Validation** - Admin-configurable attendance time windows
✅ **Bulk Operations** - Import/Export employees, bulk payroll generation
✅ **Visual Calendar** - Leave calendar with color-coded events
✅ **Document Management** - Centralized employee document storage
✅ **Comprehensive Reporting** - PDF and Excel exports
✅ **Auto-Calculations** - Worked hours, late detection, leave balance
✅ **Dashboard Analytics** - Real-time metrics and quick actions

## 🔧 Core Technologies

- **Backend:** Laravel 12 (PHP 8.2)
- **Frontend:** Bootstrap 5, Bootstrap Icons
- **Database:** MySQL
- **Libraries:** 
  - FullCalendar - Calendar views
  - Maatwebsite Excel - Data export/import
  - DomPDF - PDF generation

## 📝 Usage

### For Employees
1. Login with employee credentials
2. Check-in/out from dashboard or attendance page
3. View personal attendance history
4. Apply for leaves
5. Download payslips
6. Update profile

### For HR/Admins
1. Manage employees (Create, Edit, Delete)
2. Import employees from Excel/CSV
3. Configure attendance time windows
4. Mark attendance manually
5. Approve/reject leave requests
6. Generate and process payroll
7. Generate reports (PDF/Excel)
8. Assign roles to users

### For Managers
1. View team attendance
2. Approve team leave requests
3. Access team reports

## 🔐 Security Features

- Password hashing with bcrypt
- CSRF protection
- **Multitenant data isolation**
- **Organization-scoped role-based access control**
- Permission-based UI rendering
- Backend authorization checks
- SQL injection prevention (Eloquent ORM)
- File upload validation
- IP logging for attendance
- **Separate SystemAdmin authentication**

## � Doceumentation

Comprehensive documentation is available in the `/docs` directory:

### Quick Links
- **[Documentation Index](docs/INDEX.md)** - Complete documentation navigation
- **[Quick Start Guide](docs/QUICK_START_GUIDE.md)** - Get started quickly
- **[Development Setup](docs/DEVELOPMENT_SETUP.md)** - Developer environment setup
- **[Deployment Guide](docs/DEPLOYMENT.md)** - Production deployment

### Core Documentation
- **[Architecture](docs/ARCHITECTURE.md)** - System architecture and design
- **[Multi-Tenancy](docs/MULTI_TENANCY.md)** - Multi-tenant implementation
- **[Security](docs/SECURITY.md)** - Security features and best practices
- **[Subscription System](docs/SUBSCRIPTION_SYSTEM_COMPLETE.md)** - Billing and subscriptions
- **[Component System](docs/COMPONENT_REFACTORING.md)** - UI component architecture (92 views refactored)

### Module Documentation
- [Employee Management](docs/MODULES/01_EMPLOYEE_MANAGEMENT.md)
- [Loans Management](docs/MODULES/02_LOANS_MANAGEMENT.md)
- [Payroll Management](docs/MODULES/03_PAYROLL_MANAGEMENT.md)
- [Attendance Management](docs/MODULES/04_ATTENDANCE_MANAGEMENT.md)
- [Leave Management](docs/MODULES/05_LEAVE_MANAGEMENT.md)
- [Performance Management](docs/MODULES/06_PERFORMANCE_MANAGEMENT.md)
- [Training & Development](docs/MODULES/07_TRAINING_DEVELOPMENT.md)
- [Recruitment Management](docs/MODULES/08_RECRUITMENT_MANAGEMENT_V2.md)
- [And more...](docs/INDEX.md)

### Support
- **[FAQ](docs/FAQ.md)** - Frequently asked questions
- **[Troubleshooting](docs/TROUBLESHOOTING.md)** - Common issues and solutions

**Total Documentation**: 37 files, 500+ pages

---

## 📄 License

This project is open-sourced software licensed under the MIT license.

---

**Built with ❤️ using Laravel & Bootstrap**
