<?php

namespace App\Console\Commands;

use App\Models\Payment;
use App\Services\MpesaService;
use Illuminate\Console\Command;

class CheckMpesaPaymentStatus extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mpesa:check-status {payment_id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check M-Pesa payment status';

    /**
     * Execute the console command.
     */
    public function handle(MpesaService $mpesaService)
    {
        $paymentId = $this->argument('payment_id');
        
        $payment = Payment::find($paymentId);
        
        if (!$payment) {
            $this->error("Payment #{$paymentId} not found");
            return 1;
        }

        $this->info("Payment Details:");
        $this->info("================");
        $this->info("ID: {$payment->id}");
        $this->info("Invoice: {$payment->invoice->invoice_number}");
        $this->info("Amount: KES {$payment->amount}");
        $this->info("Status: {$payment->status}");
        $this->info("Phone: {$payment->mpesa_phone_number}");
        
        if ($payment->mpesa_receipt_number) {
            $this->info("Receipt: {$payment->mpesa_receipt_number}");
        }
        
        if ($payment->completed_at) {
            $this->info("Completed: {$payment->completed_at}");
        }
        
        $this->newLine();

        if ($payment->mpesa_checkout_request_id) {
            $this->info("Querying M-Pesa for latest status...");
            $result = $mpesaService->queryTransactionStatus($payment->mpesa_checkout_request_id);
            
            if ($result['success']) {
                $this->info("M-Pesa Response:");
                $this->line(json_encode($result['data'], JSON_PRETTY_PRINT));
            } else {
                $this->error("Failed to query status: " . $result['message']);
            }
        }

        return 0;
    }
}
