<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\TodayAttendanceSeeder;

class GenerateTodayAttendance extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'attendance:generate-today {--force : Force regenerate even if data exists}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate sample attendance data for all active employees for today';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('🕐 Generating today\'s attendance data...');
        
        // Check if attendance data already exists for today
        $existingCount = \App\Models\Attendance::whereDate('date', today())->count();
        
        if ($existingCount > 0 && !$this->option('force')) {
            $this->warn("⚠️  Attendance data already exists for today ({$existingCount} records).");
            
            if (!$this->confirm('Do you want to regenerate the data? This will delete existing records.')) {
                $this->info('Operation cancelled.');
                return 0;
            }
        }

        // Run the seeder
        $seeder = new TodayAttendanceSeeder();
        $seeder->setCommand($this);
        $seeder->run();

        $this->newLine();
        $this->info('🎉 Attendance data generation completed!');
        $this->info('💡 You can view the data in your attendance dashboard.');

        return 0;
    }
}