<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Organization;

class ListOrganizations extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'org:list';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'List all organizations';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $organizations = Organization::withCount(['users', 'employees'])->get();
        
        if ($organizations->isEmpty()) {
            $this->info('No organizations found.');
            return;
        }
        
        $headers = ['ID', 'Name', 'Slug', 'Status', 'Users', 'Employees', 'Created'];
        $rows = [];
        
        foreach ($organizations as $org) {
            $rows[] = [
                $org->id,
                $org->name,
                $org->slug,
                $org->status,
                $org->users_count,
                $org->employees_count,
                $org->created_at->format('Y-m-d'),
            ];
        }
        
        $this->table($headers, $rows);
    }
}