<?php

namespace App\Console\Commands;

use App\Services\SubscriptionService;
use Illuminate\Console\Command;

class ProcessExpiredTrials extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'subscription:process-expired-trials';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process expired trial subscriptions';

    /**
     * Execute the console command.
     */
    public function handle(SubscriptionService $subscriptionService)
    {
        $this->info('Processing expired trials...');

        $count = $subscriptionService->processExpiredTrials();

        $this->info("Processed {$count} expired trial(s)");

        return 0;
    }
}
