<?php

namespace App\Exports;

use App\Models\AuditLog;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class AuditLogsExport implements FromQuery, WithHeadings, WithMapping, WithColumnFormatting, ShouldAutoSize
{
    protected Builder $query;

    public function __construct(Builder $query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query->with(['user', 'organization']);
    }

    public function headings(): array
    {
        return [
            'ID',
            'Date & Time',
            'User',
            'Organization',
            'Event Type',
            'Category',
            'Severity',
            'Description',
            'Entity Type',
            'Entity ID',
            'IP Address',
            'User Agent',
            'URL',
            'Method',
            'Old Values',
            'New Values',
            'Metadata',
        ];
    }

    public function map($auditLog): array
    {
        return [
            $auditLog->id,
            $auditLog->created_at->format('Y-m-d H:i:s'),
            $auditLog->user ? $auditLog->user->name : 'System',
            $auditLog->organization ? $auditLog->organization->name : 'System',
            $auditLog->event_type,
            $auditLog->category,
            $auditLog->severity,
            $auditLog->description,
            $auditLog->auditable_type ? class_basename($auditLog->auditable_type) : '',
            $auditLog->auditable_id ?? '',
            $auditLog->ip_address ?? '',
            $auditLog->user_agent ?? '',
            $auditLog->url ?? '',
            $auditLog->method ?? '',
            $auditLog->old_values ? json_encode($auditLog->old_values) : '',
            $auditLog->new_values ? json_encode($auditLog->new_values) : '',
            $auditLog->metadata ? json_encode($auditLog->metadata) : '',
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_NUMBER,
            'B' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }
}