<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Services\ThemeService;

class InjectTheme
{
    /**
     * Theme service instance
     */
    protected ThemeService $themeService;

    /**
     * Create a new middleware instance
     */
    public function __construct(ThemeService $themeService)
    {
        $this->themeService = $themeService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Only inject theme for web routes (skip API, AJAX without HTML response)
        if ($this->shouldInjectTheme($request)) {
            $themeName = $this->themeService->getCurrentTheme();
            $theme = $this->themeService->getThemeConfig();
            
            // Share with views (single source of truth)
            view()->share('currentTheme', $themeName);
            view()->share('themeConfig', $theme);
        }
        
        return $next($request);
    }

    /**
     * Determine if theme should be injected for this request
     */
    protected function shouldInjectTheme(Request $request): bool
    {
        // Skip for API routes
        if ($request->is('api/*')) {
            return false;
        }

        // Skip for AJAX requests that don't expect HTML
        if ($request->ajax() && !$request->wantsHtml()) {
            return false;
        }

        // Skip for unauthenticated routes (login, register, etc.)
        // Theme will use defaults from config
        
        return true;
    }
}
