<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TenantScopeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();

        // Skip scoping for SytemAdmins - they can see everything
        if ($user && $user->is_system_admin) {
            return $next($request);
        }

        // Apply organization scoping for regular users
        if ($user && $user->organization_id) {
            // Bind the organization ID to the service container
            app()->instance('tenant.organization_id', $user->organization_id);
        }

        return $next($request);
    }
}