<?php

namespace App\Mail;

use App\Models\Interview;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\Concerns\UsesOrganizationMailSettings;

class InterviewInvitation extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels, UsesOrganizationMailSettings;

    public $interview;

    public function __construct(Interview $interview)
    {
        $this->interview = $interview;
    }

    /**
     * Get the organization for mail configuration
     */
    protected function getOrganization()
    {
        return $this->interview->application->jobPosting->organization ?? null;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Interview Invitation - ' . $this->interview->application->jobPosting->title,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.interview-invitation',
            with: [
                'interview' => $this->interview,
                'confirmUrl' => route('interview.show', $this->interview->confirmation_token),
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
