<?php

namespace App\Mail;

use App\Models\JobOffer;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\Concerns\UsesOrganizationMailSettings;

class JobOfferSent extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels, UsesOrganizationMailSettings;

    public $offer;

    public function __construct(JobOffer $offer)
    {
        $this->offer = $offer;
    }

    /**
     * Get the organization for mail configuration
     */
    protected function getOrganization()
    {
        return $this->offer->application->jobPosting->organization ?? null;
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Job Offer - ' . $this->offer->position_title,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.job-offer-sent',
            with: [
                'offer' => $this->offer,
                'offerUrl' => route('offer.view', $this->offer->offer_token),
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
