<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class ApplicationStatusHistory extends Model
{
    use HasFactory, HasTenantScope;

    protected $table = 'application_status_histories';

    protected $fillable = [
        'application_id',
        'organization_id',
        'from_status',
        'to_status',
        'changed_by',
        'notes',
    ];

    /**
     * Get the application that owns the status history
     */
    public function application()
    {
        return $this->belongsTo(Application::class);
    }

    /**
     * Get the user who changed the status
     */
    public function changedBy()
    {
        return $this->belongsTo(User::class, 'changed_by');
    }

    /**
     * Get formatted status change description
     */
    public function getDescriptionAttribute()
    {
        if ($this->from_status === null) {
            return "Application submitted";
        }
        
        return "Status changed from " . ucfirst($this->from_status) . " to " . ucfirst($this->to_status);
    }
}