<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class AttendanceSetting extends Model
{
    use HasTenantScope;
    protected $fillable = [
        'check_in_start',
        'check_in_end',
        'check_out_start',
        'check_out_end',
        'work_start_time',
        'work_end_time',
        'late_threshold_minutes',
        'early_leave_threshold_minutes',
        'half_day_hours',
        'full_day_hours',
        'allow_weekend_checkin',
        'require_checkout',
        'organization_id',
    ];

    protected $casts = [
        'allow_weekend_checkin' => 'boolean',
        'require_checkout' => 'boolean',
    ];

    public static function getSettings()
    {
        $settings = self::first();
        
        if (!$settings) {
            // Create with default values
            $settings = self::create([
                'check_in_start' => '06:00',
                'check_in_end' => '10:00',
                'check_out_start' => '15:00',
                'check_out_end' => '20:00',
                'work_start_time' => '08:00:00',
                'work_end_time' => '17:00:00',
                'late_threshold_minutes' => 15,
                'early_leave_threshold_minutes' => 30,
                'half_day_hours' => 4,
                'full_day_hours' => 8,
                'allow_weekend_checkin' => false,
                'require_checkout' => true,
            ]);
        }
        
        return $settings;
    }
}
