<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class LearningPathStep extends Model
{
    use HasTenantScope;

    protected $fillable = [
        'learning_path_id',
        'organization_id',
        'training_program_id',
        'step_order',
        'is_required',
        'prerequisites',
    ];

    protected $casts = [
        'prerequisites' => 'array',
        'is_required' => 'boolean',
    ];

    public function learningPath()
    {
        return $this->belongsTo(LearningPath::class);
    }

    public function trainingProgram()
    {
        return $this->belongsTo(TrainingProgram::class);
    }

    public function scopeRequired($query)
    {
        return $query->where('is_required', true);
    }

    public function scopeOptional($query)
    {
        return $query->where('is_required', false);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('step_order');
    }

    public function hasPrerequisites()
    {
        return !empty($this->prerequisites);
    }

    public function getPrerequisiteSteps()
    {
        if (!$this->hasPrerequisites()) {
            return collect();
        }

        return $this->learningPath->steps()
            ->whereIn('step_order', $this->prerequisites)
            ->get();
    }
}