<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class PerformanceCompetency extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'name',
        'description',
        'category',
        'skill_levels',
        'is_active',
        'organization_id',
    ];

    protected $casts = [
        'skill_levels' => 'array',
        'is_active' => 'boolean',
    ];

    public function competencyRatings()
    {
        return $this->hasMany(PerformanceCompetencyRating::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }

    public function getCategoryColorAttribute()
    {
        return match($this->category) {
            'technical' => 'primary',
            'behavioral' => 'success',
            'leadership' => 'warning',
            'core' => 'info',
            default => 'secondary'
        };
    }

    public function getSkillLevelDescription($level)
    {
        return $this->skill_levels[$level] ?? 'Not defined';
    }
}