<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class PerformanceCompetencyRating extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'performance_review_id',
        'organization_id',
        'performance_competency_id',
        'self_rating',
        'manager_rating',
        'self_comments',
        'manager_comments',
        'weight',
    ];

    protected $casts = [
        'self_rating' => 'integer',
        'manager_rating' => 'integer',
        'weight' => 'decimal:2',
    ];

    public function performanceReview()
    {
        return $this->belongsTo(PerformanceReview::class);
    }

    public function performanceCompetency()
    {
        return $this->belongsTo(PerformanceCompetency::class);
    }

    public function getRatingGap()
    {
        if ($this->self_rating && $this->manager_rating) {
            return $this->manager_rating - $this->self_rating;
        }
        return null;
    }

    public function getAverageRating()
    {
        $ratings = array_filter([$this->self_rating, $this->manager_rating]);
        return count($ratings) > 0 ? array_sum($ratings) / count($ratings) : null;
    }
}