<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class Skill extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'name',
        'description',
        'category',
        'active',
        'organization_id',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    public function employees()
    {
        return $this->belongsToMany(Employee::class, 'employee_skills')
            ->withPivot('proficiency_level', 'acquired_date', 'notes')
            ->withTimestamps();
    }

    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function trainingPrograms()
    {
        return $this->belongsToMany(TrainingProgram::class, 'training_program_skills')
            ->withPivot('skill_level_improvement', 'is_primary_skill')
            ->withTimestamps();
    }

    public function getRelatedTrainingsAttribute()
    {
        return $this->trainingPrograms()
            ->where('is_active', true)
            ->orderBy('training_program_skills.is_primary_skill', 'desc')
            ->get();
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }
}
