<?php

namespace App\Policies;

use App\Models\PerformanceGoal;
use App\Models\User;

class PerformanceGoalPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_performance');
    }

    public function view(User $user, PerformanceGoal $performanceGoal): bool
    {
        // Users can view their own goals
        if ($user->employee && $user->employee->id === $performanceGoal->employee_id) {
            return true;
        }

        // Managers can view their team's goals
        if ($user->employee && $performanceGoal->employee->manager_id === $user->employee->id) {
            return true;
        }

        return $user->can('view_performance');
    }

    public function create(User $user): bool
    {
        return $user->can('create_performance');
    }

    public function update(User $user, PerformanceGoal $performanceGoal): bool
    {
        // Goal owner can update progress
        if ($user->employee && $user->employee->id === $performanceGoal->employee_id) {
            return true;
        }

        // Managers can update their team's goals
        if ($user->employee && $performanceGoal->employee->manager_id === $user->employee->id) {
            return true;
        }

        return $user->can('edit_performance');
    }

    public function delete(User $user, PerformanceGoal $performanceGoal): bool
    {
        return $user->can('delete_performance');
    }
}