<?php

namespace App\Policies;

use App\Models\PerformanceSelfAssessment;
use App\Models\User;

class PerformanceSelfAssessmentPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->employee || $user->can('view_performance');
    }

    public function view(User $user, PerformanceSelfAssessment $selfAssessment): bool
    {
        // Users can view their own self-assessments
        if ($user->employee && $user->employee->id === $selfAssessment->employee_id) {
            return true;
        }

        // Managers can view their team's self-assessments
        if ($user->employee && $selfAssessment->employee && 
            isset($selfAssessment->employee->manager_id) && 
            $selfAssessment->employee->manager_id === $user->employee->id) {
            return true;
        }

        return $user->can('view_performance');
    }

    public function create(User $user): bool
    {
        return $user->employee || $user->can('create_performance');
    }

    public function update(User $user, PerformanceSelfAssessment $selfAssessment): bool
    {
        // Users can only update their own draft self-assessments
        if ($user->employee && $user->employee->id === $selfAssessment->employee_id && $selfAssessment->status === 'draft') {
            return true;
        }

        return $user->can('edit_performance');
    }

    public function delete(User $user, PerformanceSelfAssessment $selfAssessment): bool
    {
        // Users can delete their own draft self-assessments
        if ($user->employee && $user->employee->id === $selfAssessment->employee_id && $selfAssessment->status === 'draft') {
            return true;
        }

        return $user->can('delete_performance');
    }
}