<?php

namespace App\Policies;

use App\Models\User;
use App\Models\TrainingProgram;

class TrainingProgramPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_training') || $user->can('manage_training');
    }

    public function view(User $user, TrainingProgram $program): bool
    {
        return $user->organization_id === $program->organization_id &&
               ($user->can('view_training') || $user->can('manage_training'));
    }

    public function create(User $user): bool
    {
        return $user->can('create_training_programs') || $user->can('manage_training');
    }

    public function update(User $user, TrainingProgram $program): bool
    {
        return $user->organization_id === $program->organization_id &&
               ($user->can('edit_training_programs') || $user->can('manage_training'));
    }

    public function delete(User $user, TrainingProgram $program): bool
    {
        return $user->organization_id === $program->organization_id &&
               ($user->can('delete_training_programs') || $user->can('manage_training'));
    }

    public function enroll(User $user): bool
    {
        return $user->employee !== null && 
               ($user->can('enroll_training') || $user->can('view_training'));
    }
}