<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use App\Models\User;
use App\Models\Employee;
use App\Policies\UserPolicy;
use App\Policies\EmployeePolicy;
use App\Policies\RolePolicy;
use App\Policies\PermissionPolicy;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        User::class => UserPolicy::class,
        Employee::class => EmployeePolicy::class,
        Role::class => RolePolicy::class,
        Permission::class => PermissionPolicy::class,
        \App\Models\Department::class => \App\Policies\DepartmentPolicy::class,
        \App\Models\Attendance::class => \App\Policies\AttendancePolicy::class,
        \App\Models\LeaveRequest::class => \App\Policies\LeaveRequestPolicy::class,
        \App\Models\Payroll::class => \App\Policies\PayrollPolicy::class,
        \App\Models\EmployeeLoan::class => \App\Policies\EmployeeLoanPolicy::class,
        \App\Models\PayrollSettings::class => \App\Policies\PayrollSettingsPolicy::class,
        \App\Models\PerformanceReview::class => \App\Policies\PerformanceReviewPolicy::class,
        \App\Models\Announcement::class => \App\Policies\AnnouncementPolicy::class,
        \App\Models\TrainingProgram::class => \App\Policies\TrainingProgramPolicy::class,
        \App\Models\TrainingSession::class => \App\Policies\TrainingSessionPolicy::class,
        \App\Models\TrainingRecommendation::class => \App\Policies\TrainingRecommendationPolicy::class,
        \App\Models\LearningPath::class => \App\Policies\LearningPathPolicy::class,
        \App\Models\TrainingPerformanceImpact::class => \App\Policies\TrainingPerformanceImpactPolicy::class,
    ];

    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // Register special gates for backward compatibility
        Gate::define('manage-roles', function ($user) {
            return $user->canManageRoles();
        });
    }
}
