<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
        then: function () {
            Route::middleware('web')
                ->group(base_path('routes/audit.php'));
        },
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Add tenant context middleware to web group
        $middleware->web(append: [
            \App\Http\Middleware\SetTenantContext::class,
            \App\Http\Middleware\InjectTheme::class,
            \App\Http\Middleware\AuditMiddleware::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \App\Http\Middleware\SanitizeInput::class,
            // Removed CheckOnboardingStatus from global - will be applied selectively
        ]);

        $middleware->alias([
            'role' => \Spatie\Permission\Middleware\RoleMiddleware::class,
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
            'role_or_permission' => \Spatie\Permission\Middleware\RoleOrPermissionMiddleware::class,
            // Keep custom middleware for backward compatibility
            'custom_role' => \App\Http\Middleware\HasRole::class,
            'custom_permission' => \App\Http\Middleware\HasPermission::class,
            // Add new multitenancy middleware
            'system_admin' => \App\Http\Middleware\SystemAdminMiddleware::class,
            'tenant_scope' => \App\Http\Middleware\TenantScopeMiddleware::class,
            // Add subscription middleware
            'subscription' => \App\Http\Middleware\CheckSubscription::class,
            'quota' => \App\Http\Middleware\CheckQuota::class,
            // Add onboarding middleware
            'onboarding' => \App\Http\Middleware\CheckOnboardingStatus::class,
            'email.verified' => \App\Http\Middleware\EnsureEmailIsVerified::class,
            // Add security middleware
            'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
            'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
            'sanitize_input' => \App\Http\Middleware\SanitizeInput::class,
            'secure_file_upload' => \App\Http\Middleware\SecureFileUpload::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        // Custom exception handling will be handled by our Handler class
        // Laravel 11 automatically uses app/Exceptions/Handler.php if it exists
    })->create();
