<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Security Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains security-related configuration options for the
    | application including rate limiting, IP whitelisting, and other
    | security measures.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Login Security
    |--------------------------------------------------------------------------
    */
    'max_login_attempts' => env('SECURITY_MAX_LOGIN_ATTEMPTS', 5),
    'lockout_duration' => env('SECURITY_LOCKOUT_DURATION', 15), // minutes
    'account_lockout_attempts' => env('SECURITY_ACCOUNT_LOCKOUT_ATTEMPTS', 10),
    'account_lockout_duration' => env('SECURITY_ACCOUNT_LOCKOUT_DURATION', 60), // minutes

    /*
    |--------------------------------------------------------------------------
    | Session Security
    |--------------------------------------------------------------------------
    */
    'session_timeout' => env('SECURITY_SESSION_TIMEOUT', 120), // minutes
    'force_https' => env('SECURITY_FORCE_HTTPS', false),
    'secure_cookies' => env('SECURITY_SECURE_COOKIES', false),

    /*
    |--------------------------------------------------------------------------
    | Two-Factor Authentication
    |--------------------------------------------------------------------------
    */
    'require_2fa' => env('SECURITY_REQUIRE_2FA', false),
    'require_2fa_for_admins' => env('SECURITY_REQUIRE_2FA_ADMINS', true),

    /*
    |--------------------------------------------------------------------------
    | Password Security
    |--------------------------------------------------------------------------
    */
    'password_expiry_days' => env('SECURITY_PASSWORD_EXPIRY_DAYS', 90),
    'password_history_count' => env('SECURITY_PASSWORD_HISTORY_COUNT', 5),
    'min_password_length' => env('SECURITY_MIN_PASSWORD_LENGTH', 8),
    'require_password_complexity' => env('SECURITY_REQUIRE_PASSWORD_COMPLEXITY', true),

    /*
    |--------------------------------------------------------------------------
    | IP Whitelisting
    |--------------------------------------------------------------------------
    */
    'ip_whitelist' => [
        // Add IP addresses or CIDR ranges that should always be allowed
        // '127.0.0.1',
        // '192.168.1.0/24',
    ],

    /*
    |--------------------------------------------------------------------------
    | File Upload Security
    |--------------------------------------------------------------------------
    */
    'max_file_size' => env('SECURITY_MAX_FILE_SIZE', 10485760), // 10MB in bytes
    'allowed_file_extensions' => [
        'jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp', // Images
        'pdf', // Documents
        'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', // Office
        'txt', 'csv', // Text
        'zip', 'rar', // Archives
    ],
    'allowed_mime_types' => [
        'image/jpeg', 'image/png', 'image/gif', 'image/bmp', 'image/webp',
        'application/pdf',
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'application/vnd.ms-excel',
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'application/vnd.ms-powerpoint',
        'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'text/plain', 'text/csv',
        'application/zip', 'application/x-rar-compressed',
    ],

    /*
    |--------------------------------------------------------------------------
    | Input Sanitization
    |--------------------------------------------------------------------------
    */
    'sanitize_input' => env('SECURITY_SANITIZE_INPUT', true),
    'strip_dangerous_tags' => env('SECURITY_STRIP_DANGEROUS_TAGS', true),
    'max_input_length' => env('SECURITY_MAX_INPUT_LENGTH', 10000),

    /*
    |--------------------------------------------------------------------------
    | Rate Limiting
    |--------------------------------------------------------------------------
    */
    'rate_limits' => [
        'login' => [
            'max_attempts' => 5,
            'decay_minutes' => 15,
        ],
        'password_reset' => [
            'max_attempts' => 3,
            'decay_minutes' => 60,
        ],
        'api' => [
            'max_attempts' => 60,
            'decay_minutes' => 1,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Headers
    |--------------------------------------------------------------------------
    */
    'security_headers' => [
        'X-Content-Type-Options' => 'nosniff',
        'X-Frame-Options' => 'DENY',
        'X-XSS-Protection' => '1; mode=block',
        'Referrer-Policy' => 'strict-origin-when-cross-origin',
        'Content-Security-Policy' => "default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://api.qrserver.com; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net; img-src 'self' data: https: blob:; font-src 'self' https://cdn.jsdelivr.net;",
    ],

    /*
    |--------------------------------------------------------------------------
    | Audit Logging
    |--------------------------------------------------------------------------
    */
    'audit_sensitive_operations' => env('SECURITY_AUDIT_SENSITIVE_OPS', true),
    'log_failed_attempts' => env('SECURITY_LOG_FAILED_ATTEMPTS', true),
    'log_suspicious_activity' => env('SECURITY_LOG_SUSPICIOUS_ACTIVITY', true),

    /*
    |--------------------------------------------------------------------------
    | Encryption
    |--------------------------------------------------------------------------
    */
    'encrypt_sensitive_data' => env('SECURITY_ENCRYPT_SENSITIVE_DATA', true),
    'hash_algorithm' => env('SECURITY_HASH_ALGORITHM', 'sha256'),
];