<?php

return [
    'default' => env('APP_THEME', 'default'),
    
    'themes' => [
        'default' => [
            'name' => 'Default Theme',
            'colors' => [
                'primary' => '#030213',
                'secondary' => '#FF6B35',
                'accent' => '#00a09d',
                'success' => '#28a745',
                'warning' => '#ffc107',
                'danger' => '#dc3545',
                'info' => '#17a2b8',
                'light' => '#f8f9fa',
                'dark' => '#343a40',
            ],
            'sidebar' => [
                'background' => '#030213',
                'text' => 'rgba(255, 255, 255, 0.8)',
                'hover' => '#FF6B35',
                'active' => '#FF6B35',
            ],
        ],
        
        'system_admin' => [
            'name' => 'System Admin Theme',
            'colors' => [
                'primary' => '#FF6B35',
                'secondary' => '#FF8C42',
                'accent' => '#030213',
                'success' => '#28a745',
                'warning' => '#ffc107',
                'danger' => '#dc3545',
                'info' => '#17a2b8',
                'light' => '#f8f9fa',
                'dark' => '#1a1a1a',
            ],
            'sidebar' => [
                'background' => 'linear-gradient(180deg, #030213 0%, #1a1a1a 100%)',
                'text' => 'rgba(255, 255, 255, 0.8)',
                'hover' => '#FF6B35',
                'active' => '#FF6B35',
            ],
        ],
        
        'blue' => [
            'name' => 'Blue Theme',
            'colors' => [
                'primary' => '#0d6efd',
                'secondary' => '#6c757d',
                'accent' => '#0dcaf0',
                'success' => '#28a745',
                'warning' => '#ffc107',
                'danger' => '#dc3545',
                'info' => '#17a2b8',
                'light' => '#f8f9fa',
                'dark' => '#343a40',
            ],
            'sidebar' => [
                'background' => '#0d6efd',
                'text' => 'rgba(255, 255, 255, 0.9)',
                'hover' => '#0dcaf0',
                'active' => '#0dcaf0',
            ],
        ],
        
        'green' => [
            'name' => 'Green Theme',
            'colors' => [
                'primary' => '#198754',
                'secondary' => '#20c997',
                'accent' => '#0dcaf0',
                'success' => '#28a745',
                'warning' => '#ffc107',
                'danger' => '#dc3545',
                'info' => '#17a2b8',
                'light' => '#f8f9fa',
                'dark' => '#343a40',
            ],
            'sidebar' => [
                'background' => '#198754',
                'text' => 'rgba(255, 255, 255, 0.9)',
                'hover' => '#20c997',
                'active' => '#20c997',
            ],
        ],
    ],
    
    'components' => [
        'card' => [
            'border_radius' => '12px',
            'shadow' => '0 2px 10px rgba(0,0,0,0.08)',
            'padding' => '1.5rem',
        ],
        'stat_card' => [
            'border_radius' => '12px',
            'icon_size' => '50px',
            'hover_transform' => 'translateY(-2px)',
        ],
    ],
];
