<?php

namespace Database\Factories;

use App\Models\JobPosting;
use App\Models\Department;
use App\Models\Position;
use App\Models\User;
use App\Models\Organization;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\JobPosting>
 */
class JobPostingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title' => $this->faker->jobTitle(),
            'department_id' => Department::factory(),
            'position_id' => null,
            'location' => $this->faker->city() . ', Kenya',
            'employment_type' => $this->faker->randomElement(['full-time', 'part-time', 'contract', 'internship']),
            'description' => $this->faker->paragraphs(3, true),
            'requirements' => $this->faker->paragraphs(2, true),
            'responsibilities' => $this->faker->paragraphs(2, true),
            'salary_range' => $this->faker->randomElement(['50,000 - 80,000', '80,000 - 120,000', '120,000 - 200,000', 'Competitive']),
            'status' => $this->faker->randomElement(['draft', 'active', 'closed']),
            'public_token' => $this->faker->unique()->sha256(),
            'closes_at' => $this->faker->optional()->dateTimeBetween('now', '+3 months'),
            'created_by' => User::factory(),
            'organization_id' => Organization::factory(),
        ];
    }

    /**
     * Indicate that the job posting is active.
     */
    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'active',
        ]);
    }

    /**
     * Indicate that the job posting is closed.
     */
    public function closed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'closed',
        ]);
    }

    /**
     * Indicate that the job posting is a draft.
     */
    public function draft(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'draft',
        ]);
    }
}