<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('last_login_at')->nullable()->after('updated_at');
            $table->timestamp('locked_until')->nullable()->after('last_login_at');
            $table->text('two_factor_secret')->nullable()->after('locked_until');
            $table->text('two_factor_recovery_codes')->nullable()->after('two_factor_secret');
            $table->timestamp('two_factor_confirmed_at')->nullable()->after('two_factor_recovery_codes');
            $table->integer('failed_login_attempts')->default(0)->after('two_factor_confirmed_at');
            $table->timestamp('last_failed_login_at')->nullable()->after('failed_login_attempts');
            $table->string('login_ip')->nullable()->after('last_failed_login_at');
            $table->text('login_user_agent')->nullable()->after('login_ip');
            
            // Add indexes for performance
            $table->index('last_login_at');
            $table->index('locked_until');
            $table->index('email_verified_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'last_login_at',
                'locked_until',
                'two_factor_secret',
                'two_factor_recovery_codes',
                'two_factor_confirmed_at',
                'failed_login_attempts',
                'last_failed_login_at',
                'login_ip',
                'login_user_agent'
            ]);
        });
    }
};