<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_offers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('application_id')->constrained()->onDelete('cascade');
            $table->string('offer_token', 64)->unique();
            $table->string('position_title');
            $table->decimal('salary', 12, 2);
            $table->enum('salary_period', ['hourly', 'monthly', 'annually'])->default('annually');
            $table->date('start_date');
            $table->text('benefits')->nullable();
            $table->text('terms_and_conditions');
            $table->string('offer_letter_path')->nullable();
            $table->enum('status', ['draft', 'sent', 'accepted', 'declined', 'expired'])->default('draft');
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->timestamp('responded_at')->nullable();
            $table->text('candidate_notes')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->foreignId('organization_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index('offer_token');
            $table->index(['application_id', 'status']);
            $table->index(['organization_id', 'status']);
        });

        // Add employee link to applications table
        Schema::table('applications', function (Blueprint $table) {
            $table->foreignId('employee_id')->nullable()->after('candidate_id')
                ->constrained('employees')->onDelete('set null');
            $table->timestamp('converted_to_employee_at')->nullable()->after('employee_id');
        });

        // Add interview confirmation fields
        Schema::table('interviews', function (Blueprint $table) {
            $table->string('confirmation_token', 64)->unique()->nullable()->after('status');
            $table->enum('candidate_response', ['pending', 'confirmed', 'declined', 'rescheduled'])
                ->default('pending')->after('confirmation_token');
            $table->timestamp('candidate_responded_at')->nullable()->after('candidate_response');
            $table->text('candidate_notes')->nullable()->after('candidate_responded_at');
            
            $table->index('confirmation_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('interviews', function (Blueprint $table) {
            $table->dropIndex(['confirmation_token']);
            $table->dropColumn(['confirmation_token', 'candidate_response', 'candidate_responded_at', 'candidate_notes']);
        });

        Schema::table('applications', function (Blueprint $table) {
            $table->dropForeign(['employee_id']);
            $table->dropColumn(['employee_id', 'converted_to_employee_at']);
        });

        Schema::dropIfExists('job_offers');
    }
};
