<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AuditPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Create audit-related permissions
        $permissions = [
            'view_audit_logs',
            'view_system_audit_logs', // System admin only - can see all organizations
            'view_organization_audit_logs', // Organization users - can see their org only
            'export_audit_logs',
            'manage_audit_settings',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'web'
            ]);
        }

        // Assign permissions to roles
        $systemAdmin = Role::where('name', 'system_admin')->first();
        $orgAdmin = Role::where('name', 'org_admin')->first();
        $hrManager = Role::where('name', 'hr_manager')->first();

        if ($systemAdmin) {
            $systemAdmin->givePermissionTo([
                'view_audit_logs',
                'view_system_audit_logs',
                'view_organization_audit_logs',
                'export_audit_logs',
                'manage_audit_settings',
            ]);
        }

        if ($orgAdmin) {
            $orgAdmin->givePermissionTo([
                'view_audit_logs',
                'view_organization_audit_logs',
                'export_audit_logs',
            ]);
        }

        if ($hrManager) {
            $hrManager->givePermissionTo([
                'view_audit_logs',
                'view_organization_audit_logs',
                'export_audit_logs',
            ]);
        }
    }
}