<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class EmailSettingsPermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Create email settings permissions if they don't exist
        $permissions = [
            'view_email_settings' => 'View email settings',
            'edit_email_settings' => 'Edit email settings',
            'test_email_settings' => 'Test email configuration',
        ];

        foreach ($permissions as $name => $description) {
            Permission::firstOrCreate(
                ['name' => $name],
                ['guard_name' => 'web']
            );
        }

        // Assign email settings permissions to org_admin role
        $orgAdminRole = Role::where('name', 'org_admin')->first();
        if ($orgAdminRole) {
            $orgAdminRole->givePermissionTo([
                'view_email_settings',
                'edit_email_settings',
                'test_email_settings',
            ]);
            $this->command->info('✓ Email settings permissions assigned to org_admin role');
        }

        // Also give these permissions to users who already have edit_organization_settings
        $editOrgSettingsPermission = Permission::where('name', 'edit_organization_settings')->first();
        if ($editOrgSettingsPermission) {
            $rolesWithOrgSettings = Role::whereHas('permissions', function ($query) {
                $query->where('name', 'edit_organization_settings');
            })->get();

            foreach ($rolesWithOrgSettings as $role) {
                $role->givePermissionTo([
                    'view_email_settings',
                    'edit_email_settings',
                    'test_email_settings',
                ]);
                $this->command->info("✓ Email settings permissions assigned to {$role->name} role");
            }
        }

        $this->command->info('✓ Email settings permissions created successfully!');
    }
}
