<?php

namespace Database\Seeders;

use App\Models\PayrollSettings;
use App\Models\Organization;
use Illuminate\Database\Seeder;

class PayrollSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first organization or create a default one
        $organization = Organization::first();
        
        if (!$organization) {
            $organization = Organization::create([
                'name' => 'Default Organization',
                'slug' => 'default',
                'email' => 'qayacreatives@gmail.com',
                'phone' => '+254700000000',
                'address' => 'Nairobi, Kenya',
                'is_active' => true,
            ]);
        }

        // Create default payroll settings
        PayrollSettings::updateOrCreate(
            ['organization_id' => $organization->id],
            [
                'paye_bands' => PayrollSettings::getDefaultPayeBands(),
                'personal_relief' => 2400,
                'insurance_relief_rate' => 0.15,
                'insurance_relief_max' => 5000,
                'pension_relief_max' => 20000,
                'pension_relief_rate' => 0.30,
                'shif_rate' => 0.0275,
                'shif_min_contribution' => 300,
                'shif_tax_deductible' => true,
                'nssf_employee_rate' => 0.06,
                'nssf_employer_rate' => 0.06,
                'nssf_lower_limit' => 9000,
                'nssf_upper_limit' => 108000,
                'nssf_max_employee_contribution' => 6480,
                'nssf_max_employer_contribution' => 6480,
                'nssf_min_contribution' => 540,
                'housing_levy_employee_rate' => 0.015,
                'housing_levy_employer_rate' => 0.015,
                'housing_levy_tax_deductible' => true,
                'housing_levy_no_max_cap' => true,
                'default_house_allowance_rate' => 0.15,
                'default_transport_allowance_rate' => 0.05,
                'max_transport_allowance' => 5000,
                'default_medical_allowance' => 2000,
                'default_monthly_working_days' => 22,
                'default_weekly_working_days' => 5,
                'default_hours_per_day' => 8,
                'kra_submission_deadline' => 9,
                'shif_submission_deadline' => 15,
                'nssf_submission_deadline' => 15,
                'housing_levy_submission_deadline' => 9,
                'config_version' => '2026.02',
                'last_regulatory_update' => now(),
                'regulatory_change_log' => [
                    [
                        'date' => '2026-02-05',
                        'change' => 'Initial setup with 2026 Kenya tax rates',
                        'details' => 'PAYE, SHIF, NSSF, and Housing Levy rates updated for 2026'
                    ]
                ],
            ]
        );
    }
}