<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TrainingCategory;
use App\Models\Organization;

class TrainingCategoriesSeeder extends Seeder
{
    public function run(): void
    {
        $organizations = Organization::all();

        $categories = [
            [
                'name' => 'Technical Skills',
                'description' => 'Programming, software development, and technical competencies',
                'color' => '#3b82f6',
            ],
            [
                'name' => 'Soft Skills',
                'description' => 'Communication, leadership, and interpersonal skills',
                'color' => '#10b981',
            ],
            [
                'name' => 'Compliance & Safety',
                'description' => 'Regulatory compliance, workplace safety, and legal requirements',
                'color' => '#f59e0b',
            ],
            [
                'name' => 'Professional Development',
                'description' => 'Career advancement, certifications, and professional growth',
                'color' => '#8b5cf6',
            ],
            [
                'name' => 'Management & Leadership',
                'description' => 'Management skills, leadership development, and team building',
                'color' => '#ef4444',
            ],
            [
                'name' => 'Customer Service',
                'description' => 'Customer relations, service excellence, and client management',
                'color' => '#06b6d4',
            ],
            [
                'name' => 'Sales & Marketing',
                'description' => 'Sales techniques, marketing strategies, and business development',
                'color' => '#84cc16',
            ],
            [
                'name' => 'Finance & Accounting',
                'description' => 'Financial management, accounting principles, and budgeting',
                'color' => '#6366f1',
            ],
        ];

        foreach ($organizations as $organization) {
            foreach ($categories as $category) {
                TrainingCategory::create([
                    'name' => $category['name'],
                    'description' => $category['description'],
                    'color' => $category['color'],
                    'is_active' => true,
                    'organization_id' => $organization->id,
                ]);
            }
        }
    }
}