<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TrainingCategory;
use App\Models\TrainingProgram;

class TrainingDataSeeder extends Seeder
{
    public function run(): void
    {
        // Create training categories
        $categories = [
            [
                'name' => 'Technical Skills',
                'description' => 'Technical training programs for employees',
                'color' => '#3498db',
                'is_active' => true,
                'organization_id' => 1
            ],
            [
                'name' => 'Soft Skills',
                'description' => 'Communication and interpersonal skills training',
                'color' => '#e74c3c',
                'is_active' => true,
                'organization_id' => 1
            ],
            [
                'name' => 'Leadership',
                'description' => 'Leadership and management training programs',
                'color' => '#f39c12',
                'is_active' => true,
                'organization_id' => 1
            ]
        ];

        foreach ($categories as $categoryData) {
            TrainingCategory::create($categoryData);
        }

        // Create training programs
        $programs = [
            [
                'title' => 'Laravel Development Fundamentals',
                'description' => 'Learn the basics of Laravel framework development',
                'training_category_id' => 1,
                'type' => 'internal',
                'delivery_method' => 'in_person',
                'duration_hours' => 16,
                'cost_per_participant' => 0,
                'max_participants' => 20,
                'prerequisites' => ['Basic PHP knowledge'],
                'learning_objectives' => ['Understand MVC pattern', 'Build basic Laravel applications'],
                'content_outline' => 'Introduction to Laravel, Routing, Controllers, Views, Models',
                'instructor_name' => 'John Doe',
                'instructor_email' => 'john@example.com',
                'difficulty_level' => 'beginner',
                'is_mandatory' => false,
                'is_active' => true,
                'created_by' => 1,
                'organization_id' => 1
            ],
            [
                'title' => 'Effective Communication Skills',
                'description' => 'Improve your communication skills in the workplace',
                'training_category_id' => 2,
                'type' => 'workshop',
                'delivery_method' => 'hybrid',
                'duration_hours' => 8,
                'cost_per_participant' => 150,
                'max_participants' => 15,
                'prerequisites' => [],
                'learning_objectives' => ['Active listening', 'Clear verbal communication', 'Written communication'],
                'content_outline' => 'Communication basics, Active listening, Presentation skills',
                'instructor_name' => 'Jane Smith',
                'instructor_email' => 'jane@example.com',
                'difficulty_level' => 'intermediate',
                'is_mandatory' => true,
                'is_active' => true,
                'created_by' => 1,
                'organization_id' => 1
            ]
        ];

        foreach ($programs as $programData) {
            TrainingProgram::create($programData);
        }

        $this->command->info('Training sample data created successfully!');
    }
}