<?php

namespace Database\Seeders;

use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Seeder;

class TrainingPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Create new training permissions
        $newPermissions = [
            // Training Recommendations permissions
            ['name' => 'view_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'create_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'manage_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'respond_team_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'view_all_training_recommendations', 'guard_name' => 'web'],
            
            // Learning Paths permissions
            ['name' => 'view_learning_paths', 'guard_name' => 'web'],
            ['name' => 'create_learning_paths', 'guard_name' => 'web'],
            ['name' => 'update_learning_paths', 'guard_name' => 'web'],
            ['name' => 'delete_learning_paths', 'guard_name' => 'web'],
            ['name' => 'view_inactive_learning_paths', 'guard_name' => 'web'],
            ['name' => 'enroll_others_learning_paths', 'guard_name' => 'web'],
            ['name' => 'manage_learning_path_enrollments', 'guard_name' => 'web'],
            ['name' => 'view_all_learning_path_progress', 'guard_name' => 'web'],
            
            // Training Performance Impact permissions
            ['name' => 'view_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'create_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'update_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'delete_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'view_all_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'view_team_training_performance', 'guard_name' => 'web'],
        ];

        foreach ($newPermissions as $permission) {
            Permission::firstOrCreate($permission);
        }

        // Get roles
        $systemAdmin = Role::where('name', 'system_admin')->first();
        $orgAdmin = Role::where('name', 'org_admin')->first();
        $hrManager = Role::where('name', 'hr_manager')->first();
        $manager = Role::where('name', 'manager')->first();
        $employee = Role::where('name', 'employee')->first();

        // Assign new permissions to System Admin (all permissions)
        if ($systemAdmin) {
            $systemAdmin->givePermissionTo(Permission::all());
        }

        // Assign new permissions to Organization Admin
        if ($orgAdmin) {
            $orgAdmin->givePermissionTo([
                'view_training_recommendations', 'create_training_recommendations', 'manage_training_recommendations',
                'view_all_training_recommendations', 'view_learning_paths', 'create_learning_paths', 'update_learning_paths',
                'delete_learning_paths', 'view_inactive_learning_paths', 'enroll_others_learning_paths',
                'manage_learning_path_enrollments', 'view_all_learning_path_progress', 'view_training_performance_impacts',
                'create_training_performance_impacts', 'update_training_performance_impacts', 'delete_training_performance_impacts',
                'view_all_training_performance_impacts'
            ]);
        }

        // Assign new permissions to HR Manager
        if ($hrManager) {
            $hrManager->givePermissionTo([
                'view_training_recommendations', 'create_training_recommendations', 'manage_training_recommendations',
                'view_all_training_recommendations', 'view_learning_paths', 'create_learning_paths', 'update_learning_paths',
                'delete_learning_paths', 'view_inactive_learning_paths', 'enroll_others_learning_paths',
                'manage_learning_path_enrollments', 'view_all_learning_path_progress', 'view_training_performance_impacts',
                'create_training_performance_impacts', 'update_training_performance_impacts', 'delete_training_performance_impacts',
                'view_all_training_performance_impacts'
            ]);
        }

        // Assign new permissions to Manager
        if ($manager) {
            $manager->givePermissionTo([
                'view_training_recommendations', 'create_training_recommendations',
                'respond_team_training_recommendations', 'view_learning_paths', 'enroll_others_learning_paths',
                'view_team_training_performance', 'create_training_performance_impacts'
            ]);
        }

        // Assign new permissions to Employee
        if ($employee) {
            $employee->givePermissionTo([
                'view_learning_paths'
            ]);
        }
    }
}