# Qaya HRM - Changelog

## Version 1.2.0 - February 8, 2026

### 🎉 Major Features

#### Organization-Specific Email Configuration
- **Email Settings Page**: New `/settings/email-setup` page for organization admins to configure custom SMTP settings
- **Dynamic SMTP Configuration**: Each organization can now use their own email server instead of system defaults
- **Supported Providers**: Gmail, Microsoft 365/Outlook, SendGrid, Mailgun, and custom SMTP servers
- **Test Email Functionality**: Test email configuration before saving settings
- **8 Mail Classes Updated**: All recruitment and employee emails now use organization-specific settings
  - ApplicationReceived
  - ApplicationStatusChanged
  - InterviewInvitation
  - InterviewScheduled
  - JobOfferSent
  - NewMessageFromCandidate
  - NewMessageFromHR
  - WelcomeNewEmployee

#### Candidate Portal & Application Tracking
- **Candidate Dashboard**: Comprehensive portal for applicants to track their applications
- **Application Tracking**: Real-time status updates with tracking URL
- **Messaging System**: Two-way communication between HR and candidates
- **Application Timeline**: Visual timeline of application progress
- **Application Editing**: Candidates can update their applications before review
- **Application Withdrawal**: Self-service application withdrawal

#### Interview Management
- **Interview Scheduling**: Schedule interviews with automatic email notifications
- **Interview Confirmation**: Candidates can confirm or decline interviews via email link
- **Interview Tracking**: Track interview status and responses
- **Calendar Integration**: Interview details with date, time, location, and meeting links

#### Job Offer Management
- **Offer Creation**: Create and customize job offers for candidates
- **Offer Letters**: Generate PDF offer letters
- **Offer Acceptance**: Candidates can accept or decline offers online
- **Automatic Onboarding**: Accepted offers trigger employee creation and welcome email
- **Offer Expiration**: Set expiration dates for job offers

#### Recruitment Analytics
- **Analytics Dashboard**: Comprehensive recruitment metrics and insights
- **Application Funnel**: Track conversion rates through recruitment stages
- **Time-to-Hire**: Monitor average time to fill positions
- **Source Tracking**: Identify best recruitment channels
- **Export Functionality**: Export analytics data for reporting

### 🔧 Technical Improvements

#### Email System
- **OrganizationMailService**: New service for dynamic SMTP configuration
- **UsesOrganizationMailSettings Trait**: Reusable trait for mail classes
- **Queue Support**: Fixed authentication issues with queued emails
- **Automatic Fallback**: Falls back to system defaults when custom email is disabled
- **Email Permissions**: New permissions for email settings management

#### Database Changes
- **Organizations Table**: Added 9 new columns for email configuration
  - `use_custom_mail` (boolean)
  - `mail_driver` (varchar)
  - `mail_host` (varchar)
  - `mail_port` (integer)
  - `mail_username` (varchar)
  - `mail_password` (varchar)
  - `mail_encryption` (varchar)
  - `mail_from_address` (varchar)
  - `mail_from_name` (varchar)
- **Application Messages Table**: New table for HR-candidate messaging
- **Job Offers Table**: New table for job offer management

#### New Commands
- **TestRecruitmentEmails**: Test all recruitment email flows
  ```bash
  php artisan recruitment:test-emails your-email@example.com
  ```

#### New Controllers
- `OrganizationEmailSettingsController` - Email settings management
- `ApplicationMessageController` - Messaging between HR and candidates
- `CandidatePortalController` - Candidate self-service portal
- `InterviewConfirmationController` - Interview confirmation workflow
- `InterviewController` - Interview scheduling and management
- `JobOfferController` - Job offer creation and management
- `OfferResponseController` - Offer acceptance/decline workflow
- `RecruitmentAnalyticsController` - Recruitment analytics and reporting

### 📚 Documentation
- Added `PHASE_1_IMPLEMENTATION_GUIDE.md` - Complete recruitment module guide
- Added email setup guides for common providers
- Added troubleshooting guides for email configuration

---

## Version 1.1.0 - February 7, 2026

### 🔄 Database Restructuring
- **Migration Consolidation**: Restructured migrations for better organization
- **Multi-tenancy Setup**: Consolidated organization multi-tenancy migrations
- **Training System**: Consolidated training and LMS system migrations
- **Payroll Integration**: Consolidated payroll enhancement migrations
- **Loan Management**: Consolidated loan management system migrations

### 🐛 Bug Fixes
- Fixed migration dependencies and ordering
- Improved database schema consistency

---

## Version 1.0.0 - February 6, 2026

### 🎨 Theme System

#### Features
- **Hybrid Architecture**: Config-based + database-driven theme system
- **4 Base Themes**: Default, System Admin, Blue, Green
- **Color Customization**: 9 customizable colors + 4 sidebar colors
- **Logo Management**: 5 logo types (main, sidebar, header, favicon, banner)
- **Font Selection**: 12+ fonts with live preview
- **Custom CSS**: Add custom CSS for advanced customization
- **Layout Preferences**: Customize sidebar and layout options

#### Performance Optimizations
- **70% Overhead Reduction**: Eliminated duplicate queries and optimized caching
- **Request-Level Caching**: Theme resolved once per request
- **Static CSS Generation**: Browser-cacheable CSS files
- **Queued Logo Uploads**: 80-90% faster logo processing
- **Smart Middleware**: Skips API routes for zero overhead
- **Multi-Level Caching**: Request, application, and browser caching

#### Components
- `ThemeService` - Singleton with request-level caching
- `ThemeController` - Full CRUD for theme management
- `LogoUploadService` - Image processing and optimization
- `ProcessLogoUpload` - Background job for logo processing
- `InjectTheme` - Middleware for theme injection
- `ThemeServiceProvider` - Service provider registration

### 🔐 System Admin Security
- **Enhanced Authentication**: Stricter rate limiting (3 attempts per 15 minutes)
- **Separate Login**: Dedicated system admin login page
- **Session Management**: Improved session handling
- **Access Control**: Enhanced permission checks

### 📖 Documentation Package
- **22 Documentation Files**: Comprehensive documentation structure
- **Module Guides**: 11 detailed module documentation files
- **Architecture Guide**: System architecture and design patterns
- **Deployment Guide**: Production deployment instructions
- **Troubleshooting Guide**: Common issues and solutions
- **FAQ**: Frequently asked questions

---

## Upgrade Guide

### From 1.1.0 to 1.2.0

1. **Run Migrations**:
   ```bash
   php artisan migrate
   ```

2. **Seed Email Permissions**:
   ```bash
   php artisan db:seed --class=EmailSettingsPermissionSeeder
   ```

3. **Clear Caches**:
   ```bash
   php artisan config:clear
   php artisan route:clear
   php artisan view:clear
   ```

4. **Configure Email Settings**:
   - Login as organization admin
   - Navigate to Settings → Email Settings
   - Configure your SMTP settings
   - Test and save

5. **Restart Queue Worker**:
   ```bash
   php artisan queue:restart
   ```

### From 1.0.0 to 1.1.0

1. **Backup Database**: Always backup before running migrations
2. **Run Migrations**: `php artisan migrate`
3. **Clear Caches**: `php artisan optimize:clear`

---

## Breaking Changes

### Version 1.2.0
- **Email Configuration**: Organizations must configure email settings to send recruitment emails
- **Mail Classes**: All mail classes now require organization context
- **Queue Processing**: Queue worker must be running for email delivery

### Version 1.1.0
- **Migration Structure**: Old migration files removed, new consolidated migrations added
- **Database Schema**: Some table structures updated

### Version 1.0.0
- **Theme System**: New theme system replaces old styling approach
- **System Admin**: Separate authentication for system admins

---

## Known Issues

### Version 1.2.0
- Email queue processing requires active queue worker
- Gmail requires App Password (not regular password)
- Some email providers may require additional configuration

### Version 1.1.0
- None reported

### Version 1.0.0
- Logo upload may be slow on first upload (fixed in 1.0.0 with queued processing)

---

## Roadmap

### Version 1.3.0 (Planned)
- Email template customization per organization
- Email delivery tracking and analytics
- Bounce handling and suppression lists
- Multi-language email support
- Advanced recruitment workflows
- Interview scheduling calendar integration

### Version 1.4.0 (Planned)
- Mobile app for employee self-service
- Advanced analytics and reporting
- Integration with external HR systems
- Automated onboarding workflows
- Performance review automation

---

## Contributors

- Andrew Ochieng - Lead Developer
- Qaya Creatives Team

---

## Support

For issues or questions:
- Check [Troubleshooting Guide](TROUBLESHOOTING.md)
- Review [FAQ](FAQ.md)
- Contact support team

---

**Last Updated**: February 8, 2026
