# Frequently Asked Questions (FAQ)

## General Questions

### What is Qaya HRM?

Qaya HRM is a comprehensive Human Resource Management System built with Laravel 12 and Bootstrap 5. It provides multitenant capabilities for managing employees, attendance, leave, payroll, performance, training, and recruitment.

---

### Who can use Qaya HRM?

Qaya HRM is designed for:
- **Organizations**: Companies of all sizes needing HR management
- **HR Departments**: HR professionals managing employee data
- **Managers**: Department heads managing teams
- **Employees**: Staff accessing self-service features
- **System Administrators**: IT professionals managing the system

---

### What are the system requirements?

**Server Requirements**:
- PHP 8.2 or higher
- MySQL 8.0+ or MariaDB 10.6+
- Nginx or Apache web server
- 4GB RAM minimum (8GB recommended)
- 20GB storage minimum

**Browser Requirements**:
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

---

### Is Qaya HRM free?

Qaya HRM is open-source software licensed under the MIT license. You can use, modify, and distribute it freely. However, you're responsible for hosting, maintenance, and support.

---

### Does Qaya HRM support multiple organizations?

Yes! Qaya HRM is built with multi-tenancy support. A single installation can serve multiple organizations with complete data isolation.

---

## Account & Access

### How do I reset my password?

1. Go to the login page
2. Click "Forgot Password?"
3. Enter your email address
4. Check your email for reset link
5. Click the link and set new password
6. Login with new password

---

### Why can't I login?

Common reasons:
- Incorrect email or password
- Account is inactive
- Account is locked (too many failed attempts)
- Using wrong login URL (SystemAdmin vs Organization)
- Browser cache issues

**Solution**: Try password reset, clear browser cache, or contact your administrator.

---

### What is Two-Factor Authentication (2FA)?

2FA adds extra security by requiring:
1. Your password (something you know)
2. A code from your phone (something you have)

This prevents unauthorized access even if someone knows your password.

---

### How do I enable 2FA?

1. Go to Profile → Security
2. Click "Enable Two-Factor Authentication"
3. Scan QR code with authenticator app (Google Authenticator, Authy)
4. Enter verification code
5. Save recovery codes securely

---

### What if I lose my 2FA device?

Use one of your recovery codes to login, then:
1. Disable 2FA
2. Set up 2FA on new device
3. Generate new recovery codes

If you don't have recovery codes, contact your administrator to reset 2FA.

---

## Employee Management

### How do I add a new employee?

1. Go to Employees → Create Employee
2. Fill in required information:
   - Personal details
   - Work information
   - Financial details
3. Upload photo (optional)
4. Click "Save"

**Required fields**: First name, last name, email, department, position, joining date, status.

---

### Can I import multiple employees at once?

Yes! Use the bulk import feature:
1. Go to Employees → Import
2. Download the template
3. Fill in employee data
4. Upload completed file
5. Review validation results
6. Confirm import

---

### How do I update employee information?

1. Go to Employees
2. Find the employee
3. Click "Edit"
4. Update information
5. Click "Save"

**Note**: You need 'edit_employees' permission.

---

### Can employees update their own information?

Yes, employees can update:
- Contact information
- Emergency contacts
- Profile photo
- Personal notes

They cannot change:
- Salary information
- Department/Position
- Employment status
- Work email

---

## Attendance Management

### How do I check in?

**From Dashboard**:
1. Click "Check In" button
2. Confirm check-in
3. System records time and IP address

**From Attendance Page**:
1. Go to Attendance
2. Click "Check In Now"
3. Confirm

**Note**: Check-in is only available during configured time window (default: 6 AM - 12 PM).

---

### What if I forget to check out?

- System may auto-check-out at end of day (if configured)
- Contact your manager or HR to manually mark check-out
- Explain the situation in your request

---

### Can I check in from home?

Depends on your organization's settings:
- If IP whitelisting is enabled, you may need VPN
- If location tracking is enabled, you may need to be at office
- Check with your HR department

---

### Why does it say I'm late?

You're marked late if you check in after:
- Official start time + late threshold
- Default: 9:00 AM + 15 minutes = 9:15 AM

Check your organization's attendance settings for exact times.

---

### How is attendance calculated?

**Status Determination**:
- **Present**: Checked in on time, worked full hours
- **Late**: Checked in after late threshold
- **Half Day**: Worked less than full day hours
- **Absent**: No check-in record

**Hours Calculation**:
- Hours Worked = Check-out Time - Check-in Time
- Breaks may be deducted (if configured)

---

## Leave Management

### How do I apply for leave?

1. Go to Leaves → Apply for Leave
2. Select leave type
3. Choose start and end dates
4. Enter reason
5. Attach documents (if required)
6. Submit application

---

### How long does leave approval take?

Depends on your organization's workflow:
- Typically 1-3 business days
- Manager receives notification immediately
- You'll be notified when approved/rejected

---

### Can I cancel my leave?

Yes, if:
- Leave is still pending (not yet approved)
- Leave hasn't started yet
- Your organization allows cancellation

Contact your manager or HR if you need to cancel approved leave.

---

### What happens to unused leave?

Depends on leave type and organization policy:
- **Annual Leave**: May be carried forward (usually max 5 days)
- **Sick Leave**: Typically doesn't carry forward
- **Other Leaves**: Check your organization's policy

Carried forward days usually expire after 3-6 months.

---

### Can I take leave with negative balance?

Depends on leave type settings:
- Some leave types allow negative balance
- Others require sufficient balance
- Check with HR for your organization's policy

---

## Payroll

### When will I receive my salary?

Check your organization's pay schedule:
- Typical pay day: 25th of each month
- May vary by organization
- Check with HR or Finance department

---

### How do I view my payslip?

1. Go to Payroll → My Payslips
2. Select month
3. Click "View" or "Download PDF"

You'll also receive email notification when payslip is ready.

---

### Why is my salary different this month?

Common reasons:
- Attendance deductions (absences, late arrivals)
- Loan repayments
- New deductions added
- Allowances changed
- Tax bracket changed

Check your payslip details or contact HR/Finance.

---

### What are the deductions on my payslip?

**Statutory Deductions** (Kenya):
- **PAYE**: Income tax (progressive rates)
- **NHIF**: Health insurance contribution
- **NSSF**: Pension contribution
- **Housing Levy**: 1.5% of gross salary

**Other Deductions**:
- Loan repayments
- HELB deductions
- Advances
- Other custom deductions

---

### How is PAYE calculated?

PAYE uses progressive tax bands:
- 0 - 24,000: 10%
- 24,001 - 32,333: 25%
- 32,334 - 500,000: 30%
- 500,001 - 800,000: 32.5%
- Above 800,000: 35%

Personal relief of KES 2,400 is deducted from total tax.

---

## Performance Management

### How often are performance reviews conducted?

Typical schedule:
- **Annual Review**: Once per year
- **Mid-Year Review**: 6-month checkpoint
- **Probation Review**: For new employees (3-6 months)
- **Continuous Feedback**: Ongoing

Check with your manager for your organization's schedule.

---

### How do I set goals?

1. Go to Performance → Goals
2. Click "Create Goal"
3. Enter goal details:
   - Title and description
   - Measurement criteria
   - Target date
   - Success metrics
4. Submit for manager approval

---

### What is a self-assessment?

A self-assessment is your own evaluation of your performance. You:
- Review your achievements
- Assess your skills
- Identify development areas
- Set future goals

This is reviewed by your manager during performance review.

---

### How are performance ratings determined?

Ratings typically consider:
- Goal achievement
- Competency evaluation
- Manager assessment
- Peer feedback (if 360-degree)
- Self-assessment

**Rating Scale** (typical):
- 5: Exceptional
- 4: Exceeds Expectations
- 3: Meets Expectations
- 2: Needs Improvement
- 1: Unsatisfactory

---

## Training & Development

### How do I enroll in training?

1. Go to Training → Training Catalog
2. Browse available programs
3. Click on program
4. Click "Enroll"
5. Submit enrollment request
6. Wait for approval (if required)

---

### Are trainings mandatory?

Depends on training type:
- **Mandatory**: Required for all (e.g., compliance training)
- **Recommended**: Suggested based on role/performance
- **Optional**: Available for self-development

Check training details for requirements.

---

### Will I get a certificate?

Yes, if:
- Training offers certification
- You complete all requirements
- You pass assessments (if applicable)
- You meet attendance requirements

Certificates are available for download after completion.

---

### Can I suggest training topics?

Yes! Most organizations welcome suggestions:
- Discuss with your manager
- Submit through training request form
- Participate in training needs surveys

---

## Recruitment

### How do I apply for a job?

1. Visit career portal: yourcompany.com/careers
2. Browse open positions
3. Click on job
4. Click "Apply Now"
5. Fill application form
6. Upload CV and documents
7. Submit application

---

### How long does the hiring process take?

Typical timeline:
- Application review: 1-2 weeks
- Interview scheduling: 1 week
- Interview rounds: 2-4 weeks
- Offer decision: 1 week
- **Total**: 4-8 weeks

Timeline varies by position and organization.

---

### Can I apply for multiple positions?

Yes! You can apply for multiple positions that match your qualifications. Each application is reviewed separately.

---

### How will I know my application status?

You'll receive email notifications for:
- Application received
- Application shortlisted
- Interview scheduled
- Application status updates
- Final decision

You can also check status on the career portal (if available).

---

## Technical Questions

### Which browsers are supported?

**Fully Supported**:
- Google Chrome 90+
- Mozilla Firefox 88+
- Microsoft Edge 90+
- Safari 14+

**Mobile Browsers**:
- Chrome Mobile
- Safari Mobile
- Firefox Mobile

---

### Can I use Qaya HRM on mobile?

Yes! The interface is responsive and works on:
- Smartphones
- Tablets
- Desktop computers

Some features work better on desktop (e.g., bulk operations, complex reports).

---

### Is my data secure?

Yes! Security measures include:
- HTTPS encryption
- Password hashing
- Two-factor authentication
- Role-based access control
- Audit logging
- Regular backups
- Data isolation (multi-tenancy)

---

### Can I export my data?

Yes! Export options:
- **Employees**: Excel, CSV
- **Attendance**: Excel, CSV, PDF
- **Leave**: Excel, PDF
- **Payroll**: Excel, PDF
- **Reports**: PDF, Excel, CSV

Permissions required for exports.

---

### Does Qaya HRM integrate with other systems?

Current integrations:
- Email services (SMTP)
- Calendar systems (Google Calendar, Outlook)
- File storage (Local, S3)

Future integrations:
- Biometric devices
- Payment gateways
- Accounting systems

---

## Troubleshooting

### The page is loading slowly

Try:
1. Clear browser cache
2. Check internet connection
3. Try different browser
4. Contact IT if problem persists

---

### I'm getting an error message

1. Take screenshot of error
2. Note what you were doing
3. Try refreshing page
4. Clear browser cache
5. Contact support with details

---

### My changes aren't saving

Check:
- Internet connection
- Form validation errors
- Required fields completed
- Permissions for the action
- Browser console for errors

---

## Getting Help

### Who do I contact for help?

**For HR-related questions**:
- HR Department
- Your manager
- HR Manager

**For technical issues**:
- IT Help Desk
- System Administrator
- Technical Support

**For account issues**:
- System Administrator
- IT Department

---

### Where can I find more information?

Resources:
- **Documentation**: Complete system documentation
- **User Guides**: Module-specific guides
- **Video Tutorials**: (if available)
- **Training Sessions**: Scheduled by HR
- **Help Desk**: Internal support portal

---

### How do I report a bug?

1. Document the issue:
   - What happened
   - Steps to reproduce
   - Expected vs actual behavior
   - Screenshots
2. Contact IT Help Desk
3. Provide all details
4. Follow up if needed

---

### Can I request new features?

Yes! Feature requests are welcome:
1. Discuss with your manager
2. Submit through proper channels
3. Explain business need
4. Provide use cases

Features are prioritized based on:
- Business value
- Number of users affected
- Implementation complexity
- Available resources

---

## Organization-Specific

### How do I change my organization settings?

**For Organization Admins**:
1. Go to Settings
2. Select category (Organization, Attendance, Leave, etc.)
3. Update settings
4. Save changes

**For Employees**:
- Contact your HR or administrator
- Settings changes require admin permissions

---

### Can we customize the system?

Yes! Customization options:
- **Branding**: Logo, colors
- **Settings**: All module configurations
- **Workflows**: Approval processes
- **Reports**: Custom report builder
- **Permissions**: Custom roles

For advanced customization, contact your IT department or system administrator.

---

### How do we add more users?

**Organization Admins can**:
1. Go to Users → Create User
2. Enter user details
3. Assign role
4. Send invitation

**SystemAdmins can**:
- Create users for any organization
- Manage organization admins
- Configure system-wide settings

---

## Compliance & Legal

### Is Qaya HRM GDPR compliant?

Qaya HRM includes GDPR-friendly features:
- Data access controls
- Audit logging
- Data export functionality
- Right to be forgotten
- Consent management

Organizations must configure and use these features appropriately.

---

### How long is data retained?

Retention depends on:
- Organization policy
- Legal requirements
- Data type

Typical retention:
- Active employees: Indefinitely
- Terminated employees: 7 years (or per local law)
- Audit logs: 1-3 years
- Backups: 30-90 days

---

### Who owns the data?

- **Organization**: Owns all data in their tenant
- **Employees**: Have rights to their personal data
- **System Provider**: Does not own organization data

Data ownership and rights should be defined in your organization's policies.

---

## Still Have Questions?

If your question isn't answered here:

1. **Check Documentation**: Review relevant module documentation
2. **Search Knowledge Base**: Look for similar questions
3. **Contact Support**: Reach out to your IT/HR department
4. **Training**: Attend user training sessions

---

**Last Updated**: February 2026
