# Employee Management Module

## Overview

The Employee Management module is the core of the Qaya HRM system, providing comprehensive tools for managing employee information, profiles, and organizational hierarchy.

---

## Features

### Core Functionality
- ✅ Complete employee profile management
- ✅ Employee hierarchy (Manager-Subordinate relationships)
- ✅ Employee status tracking (Active, Inactive, On Leave, Terminated)
- ✅ Photo upload and management
- ✅ Emergency contact information
- ✅ Bank account details for payroll
- ✅ KRA, NHIF, NSSF information (Kenya tax compliance)
- ✅ HELB loan tracking
- ✅ Excel/CSV import/export
- ✅ Group by Department, Position, or Status
- ✅ Advanced search and filtering

---

## Employee Information Structure

### Personal Information
- **Basic Details**
  - First Name, Last Name
  - Employee Code (Auto-generated unique identifier)
  - Email, Phone, Mobile
  - Date of Birth
  - Gender (Male, Female, Other)
  - Marital Status (Single, Married, Divorced, Widowed)
  - Nationality

- **Identification**
  - National ID / Identification Number
  - KRA PIN (Kenya Revenue Authority)
  - NHIF Number (National Hospital Insurance Fund)
  - NSSF Number (National Social Security Fund)
  - Passport ID
  - Work Permit
  - Visa Number & Expiry Date

### Work Information
- Department
- Position/Job Title
- Manager (Reporting to)
- Coach (Optional mentor)
- Work Location
- Work Email
- Work Phone
- Joining Date
- Employment Status

### Financial Information
- Basic Salary
- Bank Name
- Bank Account Number
- Bank Account Holder Name
- Bank IFSC/Branch Code
- HELB Loan Status
- HELB Monthly Deduction Amount

### Address Information
- Street Address
- City
- State/Province
- ZIP/Postal Code
- Country

### Emergency Contact
- Contact Name
- Contact Phone
- Relationship

### Additional Information
- Profile Photo
- Notes
- Company Admin Flag

---

## User Interface

### Employee List View

**Access**: Dashboard → Employees

**Features**:
- Paginated employee list
- Search by name, email, or employee code
- Filter by:
  - Department
  - Position
  - Status (Active, Inactive, On Leave, Terminated)
- Group by:
  - Department
  - Position
  - Status
- Bulk actions
- Export to Excel/CSV

**Columns Displayed**:
- Photo
- Employee Code
- Name
- Email
- Department
- Position
- Status
- Actions (View, Edit, Delete)

### Employee Detail View

**Access**: Employees → Click employee name

**Tabs**:
1. **Overview**
   - Personal information
   - Work information
   - Contact details

2. **Documents**
   - Uploaded documents
   - Document management

3. **Attendance**
   - Attendance history
   - Statistics

4. **Leave**
   - Leave requests
   - Leave balance

5. **Payroll**
   - Payroll history
   - Salary information

6. **Performance**
   - Performance reviews
   - Goals and assessments

7. **Training**
   - Training enrollments
   - Completed trainings

### Create/Edit Employee Form

**Sections**:

1. **Personal Information**
   ```
   - First Name *
   - Last Name *
   - Email *
   - Phone
   - Mobile
   - Date of Birth
   - Gender
   - Marital Status
   - Nationality
   ```

2. **Identification**
   ```
   - National ID
   - KRA PIN
   - NHIF Number
   - NSSF Number
   - Passport ID
   - Work Permit
   - Visa Number
   - Visa Expiry Date
   ```

3. **Work Information**
   ```
   - Employee Code (Auto-generated)
   - Department *
   - Position *
   - Manager
   - Coach
   - Work Location
   - Work Email
   - Work Phone
   - Joining Date *
   - Status *
   ```

4. **Financial Information**
   ```
   - Basic Salary *
   - Bank Name
   - Bank Account Number
   - Bank Account Holder
   - Bank IFSC Code
   - Has HELB Loan (Checkbox)
   - HELB Monthly Deduction
   ```

5. **Address**
   ```
   - Street Address
   - City
   - State
   - ZIP Code
   - Country
   ```

6. **Emergency Contact**
   ```
   - Contact Name
   - Contact Phone
   - Relationship
   ```

7. **Additional**
   ```
   - Profile Photo (Upload)
   - Notes (Textarea)
   - Is Company Admin (Checkbox)
   ```

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Employees | `view_employees` | View employee list and details |
| Create Employee | `create_employees` | Add new employees |
| Edit Employee | `edit_employees` | Modify employee information |
| Delete Employee | `delete_employees` | Remove employees (soft delete) |
| Import Employees | `create_employees` | Bulk import from Excel/CSV |
| Export Employees | `view_employees` | Export employee data |

---

## API Endpoints

### List Employees
```http
GET /employees
```

**Query Parameters**:
- `search` - Search term
- `department_id` - Filter by department
- `position_id` - Filter by position
- `status` - Filter by status
- `group_by` - Group results (department, position, status)
- `page` - Page number
- `per_page` - Items per page

**Response**:
```json
{
  "data": [
    {
      "id": 1,
      "employee_code": "EMP001",
      "first_name": "John",
      "last_name": "Doe",
      "email": "john.doe@example.com",
      "department": {
        "id": 1,
        "name": "IT Department"
      },
      "position": {
        "id": 1,
        "name": "Software Developer"
      },
      "status": "active"
    }
  ],
  "meta": {
    "current_page": 1,
    "total": 50
  }
}
```

### Get Employee Details
```http
GET /employees/{id}
```

### Create Employee
```http
POST /employees
```

**Request Body**:
```json
{
  "first_name": "John",
  "last_name": "Doe",
  "email": "john.doe@example.com",
  "phone": "+254712345678",
  "department_id": 1,
  "position_id": 1,
  "basic_salary": 50000,
  "joining_date": "2024-01-15",
  "status": "active"
}
```

### Update Employee
```http
PUT /employees/{id}
```

### Delete Employee
```http
DELETE /employees/{id}
```

### Import Employees
```http
POST /employees/import
```

**Request**: Multipart form data with Excel/CSV file

### Export Employees
```http
GET /employees/export
```

**Query Parameters**:
- `format` - excel or csv
- `filters` - JSON encoded filters

---

## Import/Export Functionality

### Excel/CSV Import

**Steps**:
1. Navigate to Employees → Import
2. Download template file
3. Fill in employee data
4. Upload completed file
5. Review validation results
6. Confirm import

**Template Columns**:
- First Name *
- Last Name *
- Email *
- Phone
- Department *
- Position *
- Basic Salary *
- Joining Date *
- Status *
- KRA PIN
- NHIF Number
- NSSF Number
- Bank Name
- Bank Account Number

**Validation Rules**:
- Email must be unique
- Department and Position must exist
- Basic Salary must be numeric
- Date format: YYYY-MM-DD
- Status: active, inactive, on_leave, terminated

### Excel/CSV Export

**Steps**:
1. Navigate to Employees
2. Apply filters (optional)
3. Click "Export" button
4. Select format (Excel or CSV)
5. Download file

**Exported Columns**:
- All employee information
- Department name
- Position name
- Manager name
- Current status

---

## Employee Hierarchy

### Manager-Subordinate Relationship

**Features**:
- Each employee can have one manager
- Managers can have multiple subordinates
- Hierarchical organization chart
- Manager-based filtering and reporting

**Use Cases**:
- Leave approval workflow
- Performance review assignments
- Team management
- Reporting structure

### Coach Relationship

**Features**:
- Optional mentorship assignment
- Separate from reporting structure
- Used for training and development
- Performance coaching

---

## Employee Status Management

### Status Types

1. **Active**
   - Currently employed
   - Full access to system
   - Included in payroll
   - Can check in/out

2. **Inactive**
   - Temporarily inactive
   - Limited system access
   - Not included in payroll
   - Cannot check in/out

3. **On Leave**
   - On extended leave
   - Limited system access
   - May be included in payroll
   - Cannot check in/out

4. **Terminated**
   - Employment ended
   - No system access
   - Not included in payroll
   - Historical data retained

### Status Change Workflow

**Steps**:
1. Navigate to employee profile
2. Click "Edit"
3. Change status field
4. Add notes (optional)
5. Save changes

**Effects**:
- User account activation/deactivation
- Payroll inclusion/exclusion
- Attendance tracking enable/disable
- System access control

---

## Employee Code Generation

### Auto-Generation Rules

**Format**: `EMP{number}`

**Examples**:
- EMP001
- EMP002
- EMP100

**Features**:
- Automatically generated on creation
- Unique across organization
- Sequential numbering
- Cannot be manually changed

---

## Search and Filtering

### Search Functionality

**Search Fields**:
- First Name
- Last Name
- Email
- Employee Code
- Phone Number

**Search Behavior**:
- Case-insensitive
- Partial matching
- Real-time results

### Filter Options

**Available Filters**:
1. **Department**
   - Dropdown list of departments
   - Multi-select support

2. **Position**
   - Dropdown list of positions
   - Multi-select support

3. **Status**
   - Active
   - Inactive
   - On Leave
   - Terminated

4. **Manager**
   - Filter by reporting manager

5. **Joining Date Range**
   - From date
   - To date

### Group By Functionality

**Group Options**:
1. **By Department**
   - Groups employees by department
   - Shows count per department
   - Collapsible sections

2. **By Position**
   - Groups employees by position
   - Shows count per position
   - Collapsible sections

3. **By Status**
   - Groups employees by status
   - Shows count per status
   - Collapsible sections

---

## Validation Rules

### Required Fields
- First Name
- Last Name
- Email (must be unique)
- Department
- Position
- Joining Date
- Status
- Basic Salary

### Email Validation
- Must be valid email format
- Must be unique within organization
- Cannot be changed if linked to user account

### Salary Validation
- Must be numeric
- Must be greater than 0
- Maximum 2 decimal places

### Date Validation
- Date of Birth: Must be at least 18 years ago
- Joining Date: Cannot be in the future
- Visa Expiry: Must be after today (if provided)

### Phone Validation
- Optional but recommended
- International format supported
- Validation for Kenya numbers (+254)

---

## Integration with Other Modules

### User Management
- Each employee can be linked to a user account
- User account creation from employee record
- Single sign-on integration

### Attendance
- Employee check-in/check-out
- Attendance history
- Late arrival tracking

### Leave Management
- Leave balance calculation
- Leave request submission
- Manager approval workflow

### Payroll
- Salary information
- Tax calculations (KRA, NHIF, NSSF)
- HELB deduction
- Bank details for payment

### Performance
- Performance reviews
- Goal setting
- Self-assessments

### Training
- Training enrollments
- Skill tracking
- Learning paths

---

## Best Practices

### Data Entry
1. Always fill required fields
2. Verify email addresses
3. Ensure KRA PIN format is correct
4. Double-check bank account numbers
5. Upload clear profile photos

### Data Management
1. Regular data audits
2. Keep information up-to-date
3. Archive terminated employees
4. Maintain data privacy
5. Regular backups

### Security
1. Limit access to sensitive information
2. Use role-based permissions
3. Audit employee data changes
4. Secure document uploads
5. Protect personal information

---

## Troubleshooting

### Common Issues

**Issue**: Cannot create employee
- **Solution**: Check required fields, verify email is unique

**Issue**: Import fails
- **Solution**: Verify template format, check for duplicate emails

**Issue**: Employee not appearing in list
- **Solution**: Check filters, verify organization scope

**Issue**: Cannot update salary
- **Solution**: Verify permission, check numeric format

**Issue**: Photo upload fails
- **Solution**: Check file size (max 2MB), verify image format

---

## Reports

### Available Reports
1. **Employee Directory**
   - Complete employee list
   - Contact information
   - Department and position

2. **New Hires Report**
   - Employees by joining date
   - Onboarding status

3. **Employee Status Report**
   - Breakdown by status
   - Trend analysis

4. **Department Distribution**
   - Employees per department
   - Headcount analysis

---

## Future Enhancements

- [ ] Organization chart visualization
- [ ] Employee self-service portal enhancements
- [ ] Advanced analytics dashboard
- [ ] Custom fields support
- [ ] Bulk status updates
- [ ] Employee lifecycle management
- [ ] Onboarding workflow
- [ ] Exit interview process

---

**Last Updated**: February 2026
