# Recruitment Management Module

## Overview

The Recruitment Management module provides end-to-end recruitment capabilities including job posting, application tracking, candidate management, interview scheduling, and recruitment analytics.

---

## Features

### Core Functionality
- ✅ Job posting creation and management
- ✅ Public career portal
- ✅ Online application submission
- ✅ CV/Resume upload and parsing
- ✅ Application tracking system (ATS)
- ✅ Candidate database
- ✅ Interview scheduling
- ✅ Candidate evaluation and scoring
- ✅ Offer management
- ✅ Recruitment reports and analytics
- ✅ Email notifications
- ✅ Integration with employee onboarding

---

## Recruitment Workflow

### End-to-End Process

```
┌──────────────────┐
│ Job Requisition  │ ──► Department requests new position
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Job Posting      │ ──► Create and publish job posting
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Applications     │ ──► Candidates apply online
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Screening        │ ──► Initial review and shortlisting
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Interviews       │ ──► Multiple interview rounds
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Evaluation       │ ──► Candidate assessment and scoring
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Offer            │ ──► Job offer extended
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Onboarding       │ ──► New employee onboarding
└──────────────────┘
```

---

## Job Posting Management

### Job Posting Structure

**Job Information**:
```
- Job Title *
- Department *
- Position/Role *
- Employment Type (Full-time/Part-time/Contract/Internship)
- Location *
- Salary Range (Optional)
- Number of Openings *
- Application Deadline *
- Job Status (Draft/Published/Closed)
```

**Job Description**:
```
- Job Summary
- Key Responsibilities
- Required Qualifications
- Preferred Qualifications
- Skills Required
- Experience Level
- Education Requirements
```

**Additional Details**:
```
- Benefits
- Work Schedule
- Travel Requirements
- Remote Work Options
- Career Growth Opportunities
- Company Culture
```

### Job Posting Workflow

```
┌──────────┐
│  Draft   │ ──► Job posting created
└────┬─────┘
     │
     ▼
┌──────────┐
│ Review   │ ──► HR/Manager review
└────┬─────┘
     │
     ▼
┌──────────┐
│Published │ ──► Live on career portal
└────┬─────┘
     │
     ▼
┌──────────┐
│  Closed  │ ──► No longer accepting applications
└──────────┘
```

---

## Public Career Portal

### Portal Features

**Homepage**:
```
┌─────────────────────────────────────────┐
│ Company Logo                             │
│ "Join Our Team"                          │
├─────────────────────────────────────────┤
│ [Search Jobs] [Filter by Department]    │
├─────────────────────────────────────────┤
│ Open Positions (12)                      │
│                                          │
│ ┌─────────────────────────────────────┐ │
│ │ Software Developer                   │ │
│ │ IT Department • Nairobi • Full-time │ │
│ │ Posted: 2 days ago                  │ │
│ │ [View Details] [Apply Now]          │ │
│ └─────────────────────────────────────┘ │
│                                          │
│ ┌─────────────────────────────────────┐ │
│ │ HR Manager                           │ │
│ │ HR Department • Nairobi • Full-time │ │
│ │ Posted: 5 days ago                  │ │
│ │ [View Details] [Apply Now]          │ │
│ └─────────────────────────────────────┘ │
└─────────────────────────────────────────┘
```

**Job Details Page**:
```
Job Title: Software Developer
Department: IT Department
Location: Nairobi, Kenya
Employment Type: Full-time
Salary Range: KES 80,000 - 120,000
Application Deadline: March 31, 2024

About the Role:
[Job description]

Responsibilities:
• [Responsibility 1]
• [Responsibility 2]
• [Responsibility 3]

Requirements:
• [Requirement 1]
• [Requirement 2]
• [Requirement 3]

[Apply for this Position]
```

### Application Form

**Applicant Information**:
```
Personal Details:
- First Name *
- Last Name *
- Email *
- Phone *
- Current Location *
- Nationality

Professional Details:
- Current Job Title
- Current Company
- Years of Experience *
- Expected Salary
- Notice Period
- Availability Date

Education:
- Highest Qualification *
- Institution
- Field of Study
- Graduation Year

Documents:
- Upload CV/Resume * (PDF, DOC, DOCX)
- Upload Cover Letter (Optional)
- Upload Portfolio (Optional)
- Upload Certificates (Optional)

Additional Information:
- How did you hear about us?
- LinkedIn Profile
- Portfolio Website
- Additional Comments

[Submit Application]
```

---

## Application Tracking System (ATS)

### Application Status

```
New             - Just submitted
Screening       - Under initial review
Shortlisted     - Passed screening
Interview       - Interview scheduled
Assessment      - Taking assessments
Offer           - Offer extended
Hired           - Accepted offer
Rejected        - Not selected
Withdrawn       - Candidate withdrew
```

### Application Management

**Application List View**:
```
Job: Software Developer (45 applications)

Filters: [Status] [Date] [Rating] [Source]

┌────────────────────────────────────────────────┐
│ John Doe                                        │
│ john.doe@email.com • +254712345678             │
│ 5 years experience • Available: Immediately    │
│ Status: Shortlisted • Rating: 4.5/5.0         │
│ Applied: Feb 10, 2024                          │
│ [View] [Schedule Interview] [Reject]          │
├────────────────────────────────────────────────┤
│ Jane Smith                                      │
│ jane.smith@email.com • +254723456789           │
│ 3 years experience • Available: 1 month        │
│ Status: Interview • Rating: 4.0/5.0           │
│ Applied: Feb 12, 2024                          │
│ [View] [Update Status] [Send Email]           │
└────────────────────────────────────────────────┘
```

**Application Detail View**:

**Tabs**:
1. **Overview**
   - Personal information
   - Professional summary
   - Application status
   - Timeline

2. **Documents**
   - CV/Resume (View/Download)
   - Cover letter
   - Certificates
   - Portfolio

3. **Evaluation**
   - Screening notes
   - Interview feedback
   - Assessment scores
   - Overall rating

4. **Communication**
   - Email history
   - Notes and comments
   - Status updates
   - Scheduled interviews

5. **Timeline**
   - Application submitted
   - Status changes
   - Interviews conducted
   - Decisions made

---

## Candidate Database

### Candidate Profile

**Information Stored**:
```
Personal:
- Name, Email, Phone
- Location, Nationality
- LinkedIn, Portfolio

Professional:
- Current position
- Experience level
- Skills
- Salary expectations

Education:
- Qualifications
- Institutions
- Certifications

Application History:
- Jobs applied for
- Application dates
- Interview history
- Outcomes

Documents:
- Latest CV
- Cover letters
- Certificates
- Work samples
```

### Candidate Search

**Search Criteria**:
- Keywords (name, skills, experience)
- Location
- Experience level
- Education
- Availability
- Salary range
- Application status
- Previous applications

---

## Interview Management

### Interview Types

1. **Phone Screening**
   - Initial contact
   - Basic qualification check
   - 15-30 minutes
   - HR conducted

2. **Technical Interview**
   - Skills assessment
   - Technical questions
   - Coding tests
   - 1-2 hours

3. **Behavioral Interview**
   - Culture fit
   - Soft skills
   - Situational questions
   - 45-60 minutes

4. **Panel Interview**
   - Multiple interviewers
   - Comprehensive evaluation
   - Team interaction
   - 1-2 hours

5. **Final Interview**
   - Senior management
   - Offer discussion
   - Final decision
   - 30-60 minutes

### Interview Scheduling

**Scheduling Process**:
1. Select candidate
2. Choose interview type
3. Select interviewers
4. Pick date and time
5. Choose location/platform
6. Send invitation
7. Confirmation from candidate
8. Calendar integration

**Interview Invitation**:
```
Subject: Interview Invitation - Software Developer Position

Dear John Doe,

We are pleased to invite you for an interview for the Software Developer position.

Interview Details:
Date: February 20, 2024
Time: 10:00 AM - 11:30 AM
Duration: 1.5 hours
Type: Technical Interview
Location: Office - Meeting Room A
Interviewers: Jane Smith (Tech Lead), Bob Johnson (Senior Developer)

Please confirm your availability by clicking the link below:
[Confirm Attendance] [Request Reschedule]

What to bring:
- Valid ID
- Portfolio (if applicable)
- Questions for us

If you have any questions, please contact us.

Best regards,
HR Team
```

### Interview Feedback

**Feedback Form**:
```
Candidate: John Doe
Position: Software Developer
Interview Type: Technical Interview
Date: February 20, 2024
Interviewer: Jane Smith

Technical Skills (1-5): ⭐⭐⭐⭐⭐
- Programming: 5/5
- Problem Solving: 4/5
- System Design: 4/5

Soft Skills (1-5): ⭐⭐⭐⭐
- Communication: 4/5
- Teamwork: 4/5
- Cultural Fit: 5/5

Strengths:
- Strong technical background
- Excellent problem-solving skills
- Good communication

Areas of Concern:
- Limited experience with specific framework
- May need mentoring initially

Overall Rating: 4.5/5.0
Recommendation: [Proceed to Next Round] [Hire] [Reject]

Additional Comments:
[Textarea]

[Submit Feedback]
```

---

## Candidate Evaluation

### Scoring System

**Evaluation Criteria**:
```
Technical Skills (30%)
- Required skills match
- Technical knowledge
- Problem-solving ability

Experience (25%)
- Years of experience
- Relevant experience
- Industry knowledge

Education (15%)
- Qualifications
- Certifications
- Continuous learning

Soft Skills (20%)
- Communication
- Teamwork
- Leadership potential

Cultural Fit (10%)
- Values alignment
- Team compatibility
- Work style

Total Score: 100%
```

**Rating Scale**:
```
5 - Exceptional (90-100%)
4 - Above Average (75-89%)
3 - Average (60-74%)
2 - Below Average (40-59%)
1 - Poor (0-39%)
```

---

## Offer Management

### Offer Letter Generation

**Offer Details**:
```
Candidate: John Doe
Position: Software Developer
Department: IT Department
Start Date: March 15, 2024

Compensation:
- Basic Salary: KES 100,000/month
- House Allowance: KES 20,000/month
- Transport Allowance: KES 10,000/month
- Total Package: KES 130,000/month

Benefits:
- Health Insurance (NHIF)
- Pension (NSSF)
- 21 days annual leave
- Professional development budget

Employment Terms:
- Employment Type: Full-time
- Probation Period: 3 months
- Notice Period: 1 month
- Work Schedule: Monday-Friday, 9 AM - 5 PM

[Generate Offer Letter] [Send to Candidate]
```

### Offer Status Tracking

```
Draft       - Offer being prepared
Pending     - Awaiting approval
Approved    - Ready to send
Sent        - Sent to candidate
Accepted    - Candidate accepted
Declined    - Candidate declined
Expired     - Offer expired
Withdrawn   - Offer withdrawn
```

---

## Recruitment Reports

### Available Reports

1. **Recruitment Pipeline Report**
   ```
   Job: Software Developer
   
   Applications: 45
   Screening: 20 (44%)
   Shortlisted: 10 (22%)
   Interview: 5 (11%)
   Offer: 2 (4%)
   Hired: 1 (2%)
   
   Conversion Rate: 2.2%
   Average Time to Hire: 28 days
   ```

2. **Source Effectiveness Report**
   - Applications by source
   - Quality by source
   - Cost per hire by source
   - Conversion rates

3. **Time-to-Hire Report**
   - Average time per stage
   - Bottlenecks identification
   - Comparison by position
   - Trend analysis

4. **Recruiter Performance Report**
   - Positions filled
   - Time to fill
   - Quality of hire
   - Candidate satisfaction

5. **Cost-per-Hire Report**
   - Advertising costs
   - Agency fees
   - Internal costs
   - Total recruitment cost

---

## Integration with Employee Module

### Onboarding Integration

**Process**:
1. Candidate accepts offer
2. Status changed to "Hired"
3. Create employee record
4. Generate employee code
5. Create user account
6. Send onboarding checklist
7. Schedule orientation
8. Assign mentor/buddy

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Job Postings | Public | Anyone can view |
| Create Job Posting | `create_job_postings` | Create new postings |
| Manage Applications | `manage_applications` | Review applications |
| Schedule Interviews | `schedule_interviews` | Arrange interviews |
| Evaluate Candidates | `evaluate_candidates` | Provide feedback |
| Make Offers | `make_offers` | Extend job offers |
| View Reports | `view_recruitment_reports` | Access reports |

---

## Best Practices

### For Recruiters
1. Write clear job descriptions
2. Respond to applications promptly
3. Maintain candidate communication
4. Provide interview feedback
5. Track recruitment metrics
6. Build talent pipeline

### For Hiring Managers
1. Define requirements clearly
2. Participate in interviews
3. Provide timely feedback
4. Make decisions promptly
5. Support onboarding process

### For Candidates
1. Complete application fully
2. Upload updated CV
3. Respond to communications
4. Prepare for interviews
5. Ask relevant questions
6. Follow up appropriately

---

## Troubleshooting

### Common Issues

**Issue**: Application not submitted
- **Solution**: Check required fields, verify file uploads

**Issue**: Cannot schedule interview
- **Solution**: Verify interviewer availability, check calendar integration

**Issue**: Offer letter not generating
- **Solution**: Ensure all offer details complete, check template

**Issue**: Candidate not receiving emails
- **Solution**: Verify email address, check spam folder

---

## Future Enhancements

- [ ] AI-powered CV screening
- [ ] Video interview integration
- [ ] Automated reference checking
- [ ] Candidate assessment tests
- [ ] Chatbot for candidate queries
- [ ] Social media integration
- [ ] Recruitment marketing automation
- [ ] Advanced analytics and predictions

---

**Last Updated**: February 2026
