# 🚀 Subscription System - Quick Start Guide

## For Developers

### Setup (5 minutes)

1. **Run Migrations**
```bash
php artisan migrate
```

2. **Seed Plans**
```bash
php artisan db:seed --class=SubscriptionPlanSeeder
```

3. **Create Demo Data (Optional)**
```bash
php artisan db:seed --class=DemoSubscriptionSeeder
```

4. **Configure M-Pesa** (Add to .env)
```env
MPESA_ENVIRONMENT=sandbox
MPESA_CONSUMER_KEY=your_key
MPESA_CONSUMER_SECRET=your_secret
MPESA_SHORTCODE=174379
MPESA_PASSKEY=your_passkey
MPESA_CALLBACK_URL=https://yourdomain.com/mpesa/callback
```

5. **Schedule Tasks** (Add to crontab)
```bash
0 0 * * * php artisan subscriptions:process-expired-trials
0 1 * * * php artisan subscriptions:generate-renewal-invoices
```

---

## For Organization Admins

### View Subscription
Navigate to: **Subscription → My Subscription**

### Pay Invoice
1. Go to **Invoices & Payments**
2. Click **Pay Now** on pending invoice
3. Enter M-Pesa phone number
4. Approve payment on phone
5. Wait for confirmation

### Upgrade Plan
1. Go to **Subscription → My Subscription**
2. Click **Upgrade Plan**
3. Select new plan
4. Confirm upgrade
5. Pay prorated invoice

### Check Usage
View usage on subscription dashboard or sidebar component

---

## For System Admins

### Manage Subscriptions
Navigate to: **SystemAdmin → Subscriptions**

### Extend Trial
1. Find organization subscription
2. Click **Extend Trial**
3. Enter number of days
4. Confirm

### Suspend Subscription
1. Find organization subscription
2. Click **Suspend**
3. Confirm action

---

## Common Tasks

### Create Subscription Programmatically
```php
$subscriptionService = app(SubscriptionService::class);
$subscription = $subscriptionService->createSubscription(
    $organization,
    $plan,
    'monthly',
    true // with trial
);
```

### Check if Organization Can Add Resource
```php
$usageService = app(UsageTrackingService::class);
if ($usageService->canAdd($organization, 'employees')) {
    // Allow creation
} else {
    // Show upgrade message
}
```

### Generate Invoice
```php
$billingService = app(BillingService::class);
$invoice = $billingService->generateSubscriptionInvoice($subscription);
```

### Test M-Pesa
```bash
php artisan mpesa:test 254712345678
```

---

## Routes Reference

### Organization Routes
- `GET /subscription` - View subscription
- `GET /subscription/plans` - View available plans
- `GET /subscription/upgrade/{plan}` - Upgrade form
- `POST /subscription/upgrade/{plan}` - Process upgrade
- `GET /organization/payments` - List invoices
- `GET /organization/payments/{invoice}/pay` - Payment page
- `POST /organization/payments/{invoice}/pay` - Initiate payment

### System Admin Routes
- `GET /systemadmin/subscriptions` - List all subscriptions
- `GET /systemadmin/subscriptions/{subscription}` - View subscription
- `POST /systemadmin/subscriptions/{subscription}/extend-trial` - Extend trial
- `POST /systemadmin/subscriptions/{subscription}/suspend` - Suspend
- `POST /systemadmin/subscriptions/{subscription}/reactivate` - Reactivate

---

## Troubleshooting

### M-Pesa Payment Not Working
1. Check .env configuration
2. Verify callback URL is accessible
3. Check logs: `storage/logs/laravel.log`
4. Test with: `php artisan mpesa:test 254712345678`

### Quota Not Enforcing
1. Check middleware is applied to route
2. Verify usage is being tracked
3. Check plan limits in database
4. Clear cache: `php artisan cache:clear`

### Trial Not Expiring
1. Run: `php artisan subscriptions:process-expired-trials`
2. Check scheduled tasks are running
3. Verify trial_ends_at date in database

---

## Support

For issues or questions:
1. Check documentation in `docs/`
2. Review code comments
3. Check logs in `storage/logs/`
4. Contact system administrator

---

**Last Updated**: February 8, 2026
