@extends('layouts.app')

@section('title', 'Edit Attendance')
@section('page-title', 'Edit Attendance')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="table-card">
                <x-page-header 
                    title="Edit Attendance Record"
                    backUrl="{{ route('attendance.show', $attendance) }}"
                    backText="Back" />

                <form action="{{ route('attendance.update', $attendance) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="employee" class="form-label">Employee</label>
                                <input type="text" class="form-control" 
                                       value="{{ $attendance->employee->full_name }}" readonly>
                                <small class="text-muted">Employee cannot be changed</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <x-form.input 
                                type="date" 
                                name="date" 
                                label="Date" 
                                required
                                :value="$attendance->date->format('Y-m-d')" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.input 
                                type="time" 
                                name="check_in" 
                                label="Check In Time"
                                :value="$attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('H:i') : ''" />
                        </div>
                        <div class="col-md-6">
                            <x-form.input 
                                type="time" 
                                name="check_out" 
                                label="Check Out Time"
                                :value="$attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('H:i') : ''" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="$attendance->status"
                                :options="[
                                    'present' => 'Present',
                                    'absent' => 'Absent',
                                    'late' => 'Late',
                                    'half_day' => 'Half Day',
                                    'on_leave' => 'On Leave',
                                    'holiday' => 'Holiday'
                                ]" />
                        </div>
                        <div class="col-md-6">
                            <!-- Empty column for spacing -->
                        </div>
                    </div>

                    <x-form.textarea 
                        name="notes" 
                        label="Notes"
                        rows="3"
                        :value="$attendance->notes"
                        placeholder="Optional notes about this attendance record" />

                    <x-form.button-group 
                        cancelUrl="{{ route('attendance.show', $attendance) }}"
                        submitText="Update Attendance"
                        submitIcon="bi-check-circle" />
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Auto-calculate worked hours when times are entered
    document.getElementById('check_in').addEventListener('change', calculateHours);
    document.getElementById('check_out').addEventListener('change', calculateHours);

    function calculateHours() {
        const checkIn = document.getElementById('check_in').value;
        const checkOut = document.getElementById('check_out').value;
        
        if (checkIn && checkOut) {
            const start = new Date('2000-01-01 ' + checkIn);
            const end = new Date('2000-01-01 ' + checkOut);
            
            if (end > start) {
                const diff = (end - start) / (1000 * 60 * 60); // hours
                console.log('Worked hours:', diff.toFixed(2));
            }
        }
    }
</script>
@endpush
@endsection
