@extends('layouts.app')
@section('title', 'Attendance Details')
@section('page-title', 'Attendance Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Attendance', 'url' => route('attendance.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="mb-0">Attendance Record</h5>
                    <div>
                        <a href="{{ route('attendance.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back to List
                        </a>
                        @can('update', $attendance)
                        <a href="{{ route('attendance.edit', $attendance) }}" class="btn btn-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        @endcan
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <x-detail-row label="Employee" :value="$attendance->employee->full_name" />
                            <x-detail-row label="Department" :value="$attendance->employee->department->name ?? 'N/A'" />
                            <x-detail-row label="Date" :value="\Carbon\Carbon::parse($attendance->date)->format('l, F d, Y')" />
                            <x-detail-row label="Status">
                                <x-status-badge :status="$attendance->status" />
                            </x-detail-row>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <x-detail-row label="Check In">
                                @if($attendance->check_in)
                                    <span class="text-success">
                                        <i class="bi bi-clock"></i>
                                        {{ \Carbon\Carbon::parse($attendance->check_in)->format('h:i A') }}
                                    </span>
                                @else
                                    <span class="text-muted">Not checked in</span>
                                @endif
                            </x-detail-row>
                            <x-detail-row label="Check Out">
                                @if($attendance->check_out)
                                    <span class="text-danger">
                                        <i class="bi bi-clock"></i>
                                        {{ \Carbon\Carbon::parse($attendance->check_out)->format('h:i A') }}
                                    </span>
                                @else
                                    <span class="text-muted">Not checked out</span>
                                @endif
                            </x-detail-row>
                            <x-detail-row label="Work Hours">
                                @if($attendance->worked_hours)
                                    <span class="text-primary">
                                        <i class="bi bi-stopwatch"></i>
                                        {{ $attendance->worked_hours_formatted }}
                                    </span>
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </x-detail-row>
                            <x-detail-row label="Overtime">
                                @if($attendance->overtime_hours > 0)
                                    <span class="text-info">
                                        <i class="bi bi-plus-circle"></i>
                                        {{ floor($attendance->overtime_hours / 60) }}h {{ $attendance->overtime_hours % 60 }}m
                                    </span>
                                @else
                                    <span class="text-muted">None</span>
                                @endif
                            </x-detail-row>
                        </table>
                    </div>
                </div>

                @if($attendance->notes)
                <div class="mt-4">
                    <h6>Notes:</h6>
                    <x-alert type="light" dismissible="false">
                        {{ $attendance->notes }}
                    </x-alert>
                </div>
                @endif

                @if($attendance->check_in_ip || $attendance->check_out_ip)
                <div class="mt-4">
                    <h6>IP Address Information:</h6>
                    <div class="row">
                        @if($attendance->check_in_ip)
                        <div class="col-md-6">
                            <small class="text-muted">Check-in IP:</small><br>
                            <code>{{ $attendance->check_in_ip }}</code>
                        </div>
                        @endif
                        @if($attendance->check_out_ip)
                        <div class="col-md-6">
                            <small class="text-muted">Check-out IP:</small><br>
                            <code>{{ $attendance->check_out_ip }}</code>
                        </div>
                        @endif
                    </div>
                </div>
                @endif
            </x-info-card>
        </div>

        <div class="col-md-4">
            <x-info-card title="Quick Actions">
                @if(!$attendance->check_out && $attendance->check_in && auth()->user()->employee && auth()->user()->employee->id == $attendance->employee_id)
                <form action="{{ route('attendance.employee.checkOut') }}" method="POST" class="mb-3">
                    @csrf
                    <button type="submit" class="btn btn-danger w-100">
                        <i class="bi bi-box-arrow-right"></i> Check Out Now
                    </button>
                </form>
                @endif

                @can('delete', $attendance)
                <form action="{{ route('attendance.destroy', $attendance) }}" method="POST" 
                      onsubmit="return confirm('Are you sure you want to delete this attendance record?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-outline-danger w-100">
                        <i class="bi bi-trash"></i> Delete Record
                    </button>
                </form>
                @endcan
            </x-info-card>

            <x-info-card title="Employee Information" class="mt-4">
                <div class="text-center mb-3">
                    <x-user-avatar :user="$attendance->employee" size="80" />
                </div>
                <table class="table table-sm table-borderless">
                    <x-detail-row label="Name" :value="$attendance->employee->full_name" />
                    <x-detail-row label="Employee ID" :value="$attendance->employee->employee_code" />
                    <x-detail-row label="Department" :value="$attendance->employee->department->name ?? 'N/A'" />
                    <x-detail-row label="Position" :value="$attendance->employee->position->name ?? 'N/A'" />
                </table>
                <a href="{{ route('employees.show', $attendance->employee) }}" class="btn btn-outline-primary btn-sm w-100">
                    <i class="bi bi-person"></i> View Employee Profile
                </a>
            </x-info-card>
        </div>
    </div>
</div>
@endsection
