@extends('layouts.auth')

@section('title', 'Login')

@section('full-page', true)

@push('styles')
<style>
    /* Login specific background image */
    .login-image-section {
        background-image: url('{{ asset('images/landing/login.jpg') }}');
    }
</style>
@endpush

@section('content')
<div class="login-container">
    <!-- Image Section -->
    <div class="image-section login-image-section">
        <div class="image-content">
            <h1>Welcome to <span class="highlight">Qaya</span><br>HRMS</h1>
            <p>Streamline your human resource management with our comprehensive solution. Track, manage, and optimize your workforce with ease.</p>
            
            <ul class="feature-list">
                <li><i class="bi bi-check-circle-fill"></i> Real-time Employee Tracking</li>
                <li><i class="bi bi-check-circle-fill"></i> Advanced Analytics & Reports</li>
                <li><i class="bi bi-check-circle-fill"></i> Multi-location Management</li>
                <li><i class="bi bi-check-circle-fill"></i> Automated Payroll Processing</li>
            </ul>

            <div class="footer-text">
                &copy; {{ date('Y') }} Qaya HRM. All rights reserved.
            </div>
        </div>
    </div>

    <!-- Form Section -->
    <div class="auth-form-section">
        <div class="auth-form">
            <div class="auth-header">
                <i class="bi bi-building"></i>
                <h2>Qaya HRM</h2>
                <p>Welcome back! Please sign in to your account.</p>
            </div>

            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Test Credentials Button -->
            <button type="button" class="btn-auth-secondary mb-3" onclick="fillTestCredentials()">
                <i class="bi bi-person-gear me-2"></i>Use Test Credentials (Admin)
            </button>

            <form method="POST" action="{{ route('login') }}">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-envelope"></i>
                        </span>
                        <input type="email"
                               class="form-control @error('email') is-invalid @enderror"
                               id="email"
                               name="email"
                               value="{{ old('email') }}"
                               placeholder="Enter your email"
                               required
                               autofocus>
                    </div>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-lock"></i>
                        </span>
                        <input type="password"
                               class="form-control @error('password') is-invalid @enderror"
                               id="password"
                               name="password"
                               placeholder="Enter your password"
                               required>
                        <button class="btn btn-outline-secondary" type="button" id="togglePassword" style="border-left: 0;">
                            <i class="bi bi-eye" id="togglePasswordIcon"></i>
                        </button>
                    </div>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4 d-flex justify-content-between align-items-center">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="remember" name="remember">
                        <label class="form-check-label" for="remember">
                            Remember me
                        </label>
                    </div>
                    <a href="{{ route('password.request') }}" class="auth-link" style="font-size: 0.9rem;">Forgot Password?</a>
                </div>

                <button type="submit" class="btn-auth-primary">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Sign In
                </button>
            </form>

            {{-- <div class="auth-footer-link">
                Don't have an account? <a href="{{ route('register') }}">Register here</a>
                <br><small class="text-muted mt-2 d-block">
                    <a href="{{ route('systemadmin.login') }}" class="text-decoration-none">
                        <i class="bi bi-shield-check"></i> SytemAdmin Access
                    </a>
                </small>
            </div> --}}
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Password toggle functionality
    const togglePassword = document.getElementById('togglePassword');
    const passwordField = document.getElementById('password');
    const togglePasswordIcon = document.getElementById('togglePasswordIcon');
    
    togglePassword.addEventListener('click', function() {
        // Toggle the type attribute
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);
        
        // Toggle the icon
        if (type === 'password') {
            togglePasswordIcon.classList.remove('bi-eye-slash');
            togglePasswordIcon.classList.add('bi-eye');
        } else {
            togglePasswordIcon.classList.remove('bi-eye');
            togglePasswordIcon.classList.add('bi-eye-slash');
        }
    });
    
    function fillTestCredentials() {
        document.getElementById('email').value = 'qayacreatives@gmail.com';
        document.getElementById('password').value = 'password';
        
        // Add a subtle animation to show the fields were filled
        const emailField = document.getElementById('email');
        const passwordField = document.getElementById('password');
        
        emailField.style.transform = 'scale(1.02)';
        passwordField.style.transform = 'scale(1.02)';
        
        setTimeout(() => {
            emailField.style.transform = 'scale(1)';
            passwordField.style.transform = 'scale(1)';
        }, 200);
    }
</script>
@endpush
