@extends('layouts.auth')

@section('title', 'Reset Password')

@section('full-page', true)

@push('styles')
<style>
    .forgot-password-image-section {
        background-image: url('{{ asset('images/landing/login.jpg') }}');
    }
</style>
@endpush

@section('content')
<div class="login-container">
    <!-- Image Section -->
    <div class="image-section forgot-password-image-section">
        <div class="image-content">
            <h1>Reset Your <span class="highlight">Password</span></h1>
            <p>Don't worry, it happens to the best of us. Enter your email address and we'll send you a link to reset your password.</p>
            
            <ul class="feature-list">
                <li><i class="bi bi-check-circle-fill"></i> Secure Password Recovery</li>
                <li><i class="bi bi-check-circle-fill"></i> Email Verification</li>
                <li><i class="bi bi-check-circle-fill"></i> Account Protection</li>
                <li><i class="bi bi-check-circle-fill"></i> Quick Access Restoration</li>
            </ul>

            <div class="footer-text">
                &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
            </div>
        </div>
    </div>

    <!-- Form Section -->
    <div class="auth-form-section">
        <div class="auth-form">
            <div class="auth-header">
                <i class="bi bi-key"></i>
                <h2>Forgot Password</h2>
                <p>Enter your email to reset your password</p>
            </div>

            @if (session('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle me-2"></i>{{ session('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    @foreach ($errors->all() as $error)
                        {{ $error }}
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('password.email') }}">
                @csrf

                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-envelope"></i>
                        </span>
                        <input type="email"
                               class="form-control @error('email') is-invalid @enderror"
                               id="email"
                               name="email"
                               value="{{ old('email') }}"
                               placeholder="Enter your email address"
                               required
                               autofocus>
                    </div>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn-auth-primary">
                    <i class="bi bi-send me-2"></i>Send Reset Link
                </button>
            </form>

            <div class="auth-footer-link">
                Remember your password? <a href="{{ route('login') }}">Back to login</a>
            </div>
        </div>
    </div>
</div>
@endsection