@extends('layouts.auth')

@section('title', 'Setup Two-Factor Authentication')

@section('content')
<div class="max-w-2xl w-full space-y-8">
    <div>
        <div class="mx-auto h-12 w-12 flex items-center justify-center rounded-full bg-green-100">
            <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
        </div>
        <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
            Two-Factor Authentication Enabled
        </h2>
        <p class="mt-2 text-center text-sm text-gray-600">
            Your account is now protected with two-factor authentication
        </p>
    </div>

    <div class="bg-white shadow rounded-lg p-6">
        <div class="space-y-6">
            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Scan QR Code</h3>
                <p class="text-sm text-gray-600 mb-4">
                    Scan this QR code with your authenticator app (Google Authenticator, Authy, etc.)
                </p>
                <div class="flex justify-center">
                    <img src="{{ $qr_code_url }}" alt="QR Code" class="border rounded">
                </div>
            </div>

            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Manual Entry</h3>
                <p class="text-sm text-gray-600 mb-2">
                    If you can't scan the QR code, enter this secret manually:
                </p>
                <div class="bg-gray-100 p-3 rounded font-mono text-sm break-all">
                    {{ $secret }}
                </div>
            </div>

            <div>
                <h3 class="text-lg font-medium text-gray-900 mb-4">Recovery Codes</h3>
                <p class="text-sm text-gray-600 mb-4">
                    Store these recovery codes in a safe place. You can use them to access your account if you lose your authenticator device.
                </p>
                <div class="bg-gray-100 p-4 rounded">
                    <div class="grid grid-cols-2 gap-2 font-mono text-sm">
                        @foreach($recovery_codes as $code)
                            <div class="bg-white p-2 rounded text-center">{{ $code }}</div>
                        @endforeach
                    </div>
                </div>
                <div class="mt-4 p-4 bg-yellow-50 rounded-md">
                    <div class="flex">
                        <div class="shrink-0">
                            <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-yellow-800">
                                Important
                            </h3>
                            <div class="mt-2 text-sm text-yellow-700">
                                <p>Save these recovery codes now. You won't be able to see them again!</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-8 flex justify-center space-x-4">
            <button onclick="window.print()" class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                </svg>
                Print Recovery Codes
            </button>
            <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                Continue to Dashboard
            </a>
        </div>
    </div>
</div>

<style>
@media print {
    body * {
        visibility: hidden;
    }
    .bg-gray-100, .bg-gray-100 * {
        visibility: visible;
    }
    .bg-gray-100 {
        position: absolute;
        left: 0;
        top: 0;
    }
}
</style>
@endsection