@extends('layouts.auth')

@section('title', 'Verify Email')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="bi bi-envelope-check"></i> Verify Your Email</h4>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="text-center mb-4">
                        <i class="bi bi-envelope-check text-primary" style="font-size: 4rem;"></i>
                        <h5 class="mt-3">Check Your Email</h5>
                        <p class="text-muted">
                            We've sent a 6-digit verification code to<br>
                            <strong>{{ $user->email }}</strong>
                        </p>
                    </div>

                    <form method="POST" action="{{ route('verification.verify.otp') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="otp_code" class="form-label">Enter Verification Code</label>
                            <input type="text" 
                                   class="form-control form-control-lg text-center @error('otp_code') is-invalid @enderror" 
                                   id="otp_code" 
                                   name="otp_code" 
                                   maxlength="6"
                                   pattern="[0-9]{6}"
                                   placeholder="000000"
                                   style="letter-spacing: 10px; font-size: 24px;"
                                   required
                                   autofocus>
                            @error('otp_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Code expires in 10 minutes
                            </small>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle"></i> Verify Email
                            </button>
                        </div>
                    </form>

                    <div class="text-center mt-4">
                        <p class="text-muted">Didn't receive the code?</p>
                        @if($canResend)
                            <form method="POST" action="{{ route('verification.send') }}" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-link">
                                    <i class="bi bi-arrow-clockwise"></i> Resend Code
                                </button>
                            </form>
                        @else
                            <button type="button" class="btn btn-link" disabled>
                                <i class="bi bi-clock"></i> Resend in {{ $secondsUntilResend }} seconds
                            </button>
                        @endif
                    </div>

                    <div class="alert alert-info mt-4">
                        <small>
                            <i class="bi bi-info-circle"></i>
                            <strong>Security Tip:</strong> Never share your verification code with anyone. 
                            Qaya HRM will never ask for your code via phone or email.
                        </small>
                    </div>
                </div>
            </div>

            <div class="text-center mt-3">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="btn btn-link text-muted">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Auto-format OTP input
document.getElementById('otp_code').addEventListener('input', function(e) {
    this.value = this.value.replace(/[^0-9]/g, '');
});

// Auto-submit when 6 digits entered
document.getElementById('otp_code').addEventListener('input', function(e) {
    if (this.value.length === 6) {
        this.form.submit();
    }
});

// Countdown timer for resend
@if(!$canResend)
let seconds = {{ $secondsUntilResend }};
const countdown = setInterval(function() {
    seconds--;
    if (seconds <= 0) {
        clearInterval(countdown);
        location.reload();
    }
    const button = document.querySelector('button[disabled]');
    if (button) {
        button.innerHTML = '<i class="bi bi-clock"></i> Resend in ' + seconds + ' seconds';
    }
}, 1000);
@endif
</script>
@endpush
@endsection
