<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interview Confirmed</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
                        <h2 class="mt-3">Interview Confirmed!</h2>
                        <p class="text-muted">Thank you for confirming your attendance.</p>

                        <div class="alert alert-info text-start mt-4">
                            <h6><i class="bi bi-calendar-event"></i> Interview Details</h6>
                            <p class="mb-1"><strong>Date & Time:</strong> {{ $interview->scheduled_at->format('l, F j, Y \a\t g:i A') }}</p>
                            @if($interview->location)
                            <p class="mb-1"><strong>Location:</strong> {{ $interview->location }}</p>
                            @endif
                            @if($interview->meeting_link)
                            <p class="mb-0"><strong>Meeting Link:</strong> <a href="{{ $interview->meeting_link }}" target="_blank">Join Virtual Meeting</a></p>
                            @endif
                        </div>

                        <p class="small text-muted">A confirmation email has been sent to {{ $interview->application->email }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
