<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Offer - {{ $offer->application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                
                @if(session('info'))
                <div class="alert alert-info">{{ session('info') }}</div>
                @endif

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-success text-white">
                        <h4 class="mb-0"><i class="bi bi-trophy"></i> Congratulations!</h4>
                    </div>
                    <div class="card-body">
                        <h2 class="mb-3">Job Offer</h2>
                        <p class="lead">We are pleased to offer you the position of <strong>{{ $offer->position_title }}</strong> at {{ $offer->application->jobPosting->organization->name }}.</p>

                        <div class="row mt-4">
                            <div class="col-md-6 mb-3">
                                <h6 class="text-muted">Position</h6>
                                <p class="mb-0"><strong>{{ $offer->position_title }}</strong></p>
                            </div>
                            @if($offer->application->jobPosting->department)
                            <div class="col-md-6 mb-3">
                                <h6 class="text-muted">Department</h6>
                                <p class="mb-0">{{ $offer->application->jobPosting->department->name }}</p>
                            </div>
                            @endif
                            <div class="col-md-6 mb-3">
                                <h6 class="text-muted">Salary</h6>
                                <p class="mb-0"><strong class="text-success">{{ $offer->formatted_salary }}</strong></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <h6 class="text-muted">Start Date</h6>
                                <p class="mb-0">{{ $offer->start_date->format('F j, Y') }}</p>
                            </div>
                        </div>

                        @if($offer->benefits)
                        <div class="mt-4">
                            <h6 class="text-muted">Benefits</h6>
                            <p style="white-space: pre-line;">{{ $offer->benefits }}</p>
                        </div>
                        @endif

                        <div class="mt-4">
                            <h6 class="text-muted">Terms & Conditions</h6>
                            <p style="white-space: pre-line;">{{ $offer->terms_and_conditions }}</p>
                        </div>

                        @if($offer->expires_at)
                        <div class="alert alert-warning mt-4">
                            <i class="bi bi-clock"></i> This offer expires on <strong>{{ $offer->expires_at->format('F j, Y') }}</strong>
                        </div>
                        @endif

                        @if($offer->status === 'sent')
                        <div class="d-grid gap-2 mt-4">
                            <a href="{{ route('offer.accept', $offer->offer_token) }}" class="btn btn-success btn-lg">
                                <i class="bi bi-check-circle"></i> Accept Offer
                            </a>
                            <a href="{{ route('offer.decline', $offer->offer_token) }}" class="btn btn-outline-danger">
                                <i class="bi bi-x-circle"></i> Decline Offer
                            </a>
                        </div>
                        @else
                        <div class="alert alert-info mt-4">
                            <strong>Status:</strong> {{ ucfirst($offer->status) }}
                        </div>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
