<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Withdrawn - {{ $application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="mb-4">
                            <i class="bi bi-check-circle text-success" style="font-size: 4rem;"></i>
                        </div>
                        <h2 class="mb-3">Application Withdrawn</h2>
                        <p class="text-muted mb-4">
                            Your application for <strong>{{ $application->jobPosting->title }}</strong> has been successfully withdrawn.
                        </p>
                        
                        <div class="alert alert-info text-start">
                            <i class="bi bi-info-circle"></i> We appreciate your interest in {{ $application->jobPosting->organization->name }}. 
                            We hope to see you apply for future opportunities!
                        </div>

                        <div class="d-grid gap-2 mt-4">
                            <a href="{{ route('candidate.track', $application->tracking_token) }}" class="btn btn-primary">
                                <i class="bi bi-eye"></i> View Application Status
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
