@props([
    'item',
    'resource',
    'canView' => true,
    'canEdit' => true,
    'canDelete' => true,
    'viewRoute' => null,
    'editRoute' => null,
    'deleteRoute' => null,
    'deleteConfirm' => 'Are you sure you want to delete this item?',
    'size' => 'sm',
])

@php
    $viewRoute = $viewRoute ?? route($resource . '.show', $item);
    $editRoute = $editRoute ?? route($resource . '.edit', $item);
    $deleteRoute = $deleteRoute ?? route($resource . '.destroy', $item);
    $btnSize = $size === 'sm' ? 'btn-sm' : '';
@endphp

<div class="btn-group btn-group-{{ $size }}">
    @if($canView)
        <a href="{{ $viewRoute }}" class="btn btn-outline-primary {{ $btnSize }}" title="View">
            <i class="bi bi-eye"></i>
        </a>
    @endif
    
    @if($canEdit)
        <a href="{{ $editRoute }}" class="btn btn-outline-secondary {{ $btnSize }}" title="Edit">
            <i class="bi bi-pencil"></i>
        </a>
    @endif
    
    @isset($extra)
        {{ $extra }}
    @endisset
    
    @if($canDelete)
        <form action="{{ $deleteRoute }}" method="POST" class="d-inline">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-outline-danger {{ $btnSize }}" 
                    onclick="return confirm('{{ $deleteConfirm }}')" title="Delete">
                <i class="bi bi-trash"></i>
            </button>
        </form>
    @endif
</div>
