@props([
    'headers' => [],
    'data' => null,
    'emptyMessage' => 'No records found',
    'emptyIcon' => 'inbox',
    'striped' => false,
    'hover' => true,
    'bordered' => false,
])

<div class="table-responsive">
    <table class="table {{ $striped ? 'table-striped' : '' }} {{ $hover ? 'table-hover' : '' }} {{ $bordered ? 'table-bordered' : '' }}">
        @if(count($headers) > 0)
            <thead>
                <tr>
                    @foreach($headers as $header)
                        <th>{{ $header }}</th>
                    @endforeach
                </tr>
            </thead>
        @endif
        
        <tbody>
            @if($data && $data->count() > 0)
                {{ $slot }}
            @else
                <tr>
                    <td colspan="{{ count($headers) }}" class="text-center py-5">
                        <x-empty-state 
                            :icon="$emptyIcon" 
                            :title="$emptyMessage" />
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

@if($data && method_exists($data, 'hasPages') && $data->hasPages())
    <div class="d-flex justify-content-center mt-4">
        {{ $data->links() }}
    </div>
@endif
