@props([
    'action',
    'method' => 'GET',
])

<div class="row mb-4">
    <div class="col-md-12">
        <div class="table-card">
            <form method="{{ strtoupper($method) }}" action="{{ $action }}" class="row g-3">
                @if(strtoupper($method) !== 'GET')
                    @csrf
                    @if(strtoupper($method) !== 'POST')
                        @method($method)
                    @endif
                @endif
                
                {{ $slot }}
                
                <div class="col-md-auto d-flex align-items-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search"></i> Filter
                    </button>
                </div>
                
                <div class="col-md-auto d-flex align-items-end">
                    <a href="{{ $action }}" class="btn btn-outline-secondary">
                        <i class="bi bi-x-circle"></i> Clear
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
