@props([
    'cancelUrl' => null,
    'cancelText' => 'Cancel',
    'submitText' => 'Submit',
    'submitIcon' => 'bi-check-circle',
    'cancelIcon' => 'bi-x-circle',
    'submitClass' => 'btn-primary',
    'alignment' => 'end' // 'start', 'center', 'end', 'between'
])

<div class="d-flex justify-content-{{ $alignment }} gap-2 mt-4">
    @if($cancelUrl)
        <a href="{{ $cancelUrl }}" class="btn btn-secondary">
            <i class="bi {{ $cancelIcon }}"></i> {{ $cancelText }}
        </a>
    @endif
    
    <button type="submit" class="btn {{ $submitClass }}">
        <i class="bi {{ $submitIcon }}"></i> {{ $submitText }}
    </button>
    
    {{ $slot }}
</div>
